import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect, useLayoutEffect, useMemo, useRef, useState } from "react";
import { EmptyLabel } from "./Nodes";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../../store/StoreContext";
import { buildFeelQNameFromXmlQName } from "../../feel/buildFeelQName";
import { Truncate } from "@patternfly/react-core/dist/js/components/Truncate";
import { DMN15_SPEC } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/Dmn15Spec";
import { invalidInlineFeelNameStyle } from "../../feel/InlineFeelNameInput";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { useFocusableElement } from "../../focus/useFocusableElement";
import { flushSync } from "react-dom";
import "./EditableNodeLabel.css";
import { useSettings } from "../../settings/DmnEditorSettingsContext";
import { getOperatingSystem, OperatingSystem } from "@kie-tools-core/operating-system";
export function EditableNodeLabel({ id, namedElement, namedElementQName, isEditing: _isEditing, setEditing: _setEditing, value, onChange, position, truncate, grow, shouldCommitOnBlur, skipValidation, onGetAllUniqueNames, fontCssProperties, setLabelHeight, enableAutoFocusing, }) {
    const displayValue = useDmnEditorStore((s) => {
        if (!value) {
            return undefined;
        }
        if (!namedElement || !namedElementQName) {
            return value;
        }
        const feelName = buildFeelQNameFromXmlQName({
            namedElement,
            importsByNamespace: s.computed(s).importsByNamespace(),
            model: s.dmn.model.definitions,
            namedElementQName,
            relativeToNamespace: s.dmn.model.definitions["@_namespace"],
        });
        return feelName.full;
    });
    const isEditing = useMemo(() => {
        return !(namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix) && _isEditing;
    }, [_isEditing, namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix]);
    const setEditing = useCallback((args) => {
        if (namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix) {
            return;
        }
        _setEditing(args);
    }, [_setEditing, namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix]);
    const [internalValue, setInternalValue] = useState(displayValue);
    useEffect(() => {
        setInternalValue(displayValue);
    }, [displayValue]);
    const _shouldCommitOnBlur = shouldCommitOnBlur !== null && shouldCommitOnBlur !== void 0 ? shouldCommitOnBlur : false;
    const [shouldCommit, setShouldCommit] = useState(_shouldCommitOnBlur);
    useEffect(() => {
        setShouldCommit(_shouldCommitOnBlur);
    }, [_shouldCommitOnBlur]);
    const restoreFocus = useCallback(() => {
        setTimeout(() => {
            var _a, _b;
            if (document.activeElement === ref.current) {
                (_b = (_a = previouslyFocusedElement.current) === null || _a === void 0 ? void 0 : _a.focus) === null || _b === void 0 ? void 0 : _b.call(_a);
            }
        }, 0);
    }, []);
    const isValid = useDmnEditorStore((s) => {
        var _a;
        if (skipValidation) {
            return true;
        }
        return DMN15_SPEC.namedElement.isValidName((_a = namedElement === null || namedElement === void 0 ? void 0 : namedElement["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(), internalValue, onGetAllUniqueNames(s));
    });
    const onBlur = useCallback(() => {
        setEditing(false);
        setShouldCommit(_shouldCommitOnBlur);
        restoreFocus();
        if (isValid && internalValue !== value && shouldCommit) {
            onChange(internalValue);
            setInternalValue(value);
        }
        else {
            console.debug(`Label change cancelled for node with label ${value}`);
            setInternalValue(value);
        }
    }, [internalValue, onChange, restoreFocus, _shouldCommitOnBlur, setEditing, shouldCommit, isValid, value]);
    const onKeyDown = useCallback((e) => {
        if (!(getOperatingSystem() === OperatingSystem.MACOS && e.metaKey)) {
            e.stopPropagation();
        }
        if (e.key === "Enter") {
            if (!isValid) {
                return;
            }
            else {
                setShouldCommit(true);
                restoreFocus();
            }
        }
        else if (e.key === "Escape") {
            setShouldCommit(false);
            restoreFocus();
        }
    }, [restoreFocus, isValid]);
    const previouslyFocusedElement = useRef();
    useLayoutEffect(() => {
        var _a, _b;
        if (isEditing) {
            previouslyFocusedElement.current = (_a = document.activeElement) !== null && _a !== void 0 ? _a : undefined;
            (_b = ref.current) === null || _b === void 0 ? void 0 : _b.focus();
        }
    }, [isEditing]);
    useLayoutEffect(() => {
        var _a;
        if (isEditing) {
            (_a = ref.current) === null || _a === void 0 ? void 0 : _a.setSelectionRange(0, 0);
        }
    }, [isEditing]);
    useEffect(() => {
        var _a, _b;
        if (isEditing) {
            (_a = ref.current) === null || _a === void 0 ? void 0 : _a.setSelectionRange(0, (_b = ref.current) === null || _b === void 0 ? void 0 : _b.value.length, "forward");
        }
    }, [isEditing]);
    const ref = useRef(null);
    useFocusableElement(ref, (enableAutoFocusing !== null && enableAutoFocusing !== void 0 ? enableAutoFocusing : true) ? id !== null && id !== void 0 ? id : namedElement === null || namedElement === void 0 ? void 0 : namedElement["@_id"] : undefined, useCallback((cb) => {
        setTimeout(() => {
            flushSync(() => {
                setEditing(true);
            });
            cb();
        }, 100);
    }, [setEditing]));
    return (_jsx("div", { className: `kie-dmn-editor--editable-node-name-input ${position} ${grow ? "grow" : ""} ${(namedElementQName === null || namedElementQName === void 0 ? void 0 : namedElementQName.prefix) ? "kie-dmn-editor--node-external" : ""}`, children: (isEditing && (_jsx("input", { spellCheck: "false", style: {
                ...fontCssProperties,
                ...(isValid ? {} : invalidInlineFeelNameStyle),
            }, onMouseDownCapture: (e) => e.stopPropagation(), onKeyDown: onKeyDown, tabIndex: -1, ref: ref, onBlur: onBlur, onChange: (e) => setInternalValue(e.target.value), value: internalValue }))) || (_jsx("span", { ref: (ref) => { var _a; return setLabelHeight === null || setLabelHeight === void 0 ? void 0 : setLabelHeight((_a = ref === null || ref === void 0 ? void 0 : ref.clientHeight) !== null && _a !== void 0 ? _a : 0); }, style: {
                whiteSpace: "pre-wrap",
                ...fontCssProperties,
                ...(isValid ? {} : invalidInlineFeelNameStyle),
            }, children: !displayValue ? (_jsx(EmptyLabel, {})) : !truncate ? (displayValue) : (_jsx(Truncate, { content: displayValue, tooltipPosition: "right-end" })) })) }));
}
export function useEditableNodeLabel(id) {
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const settings = useSettings();
    const [isEditingLabel, setEditingLabel] = useState(!!id && !!dmnEditorStoreApi.getState().focus.consumableId && dmnEditorStoreApi.getState().focus.consumableId === id);
    const triggerEditing = useCallback((e) => {
        if (settings.isReadOnly) {
            return;
        }
        e.stopPropagation();
        e.preventDefault();
        setEditingLabel(true);
    }, [settings.isReadOnly]);
    const triggerEditingIfEnter = useCallback((e) => {
        if (e.key === "Enter") {
            triggerEditing(e);
        }
    }, [triggerEditing]);
    return useMemo(() => ({ isEditingLabel, setEditingLabel, triggerEditing, triggerEditingIfEnter }), [isEditingLabel, triggerEditing, triggerEditingIfEnter]);
}
//# sourceMappingURL=EditableNodeLabel.js.map