import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useDmnEditorStore } from "../../store/StoreContext";
import { TypeRefSelector } from "../../dataTypes/TypeRefSelector";
import { useDmnEditor } from "../../DmnEditorContext";
import { useResolvedTypeRef } from "../../dataTypes/useResolvedTypeRef";
function stopPropagation(e) {
    e.stopPropagation();
}
export function DataTypeNodePanel(props) {
    var _a;
    const enableDataTypesToolbarOnNodes = useDmnEditorStore((s) => s.diagram.overlays.enableDataTypesToolbarOnNodes);
    const { dmnEditorRootElementRef } = useDmnEditor();
    const resolvedTypeRef = useResolvedTypeRef((_a = props.variable) === null || _a === void 0 ? void 0 : _a["@_typeRef"], props.dmnObjectNamespace);
    const isExternalNode = !!props.dmnObjectNamespace;
    return (_jsx(_Fragment, { children: props.isVisible && enableDataTypesToolbarOnNodes && (_jsx("div", { className: `kie-dmn-editor--data-type-node-panel ${props.isReadOnly ? "kie-dmn-editor--data-type-node-panel-readonly" : ""}`, onMouseDownCapture: stopPropagation, onKeyDownCapture: stopPropagation, onClick: stopPropagation, onDoubleClick: stopPropagation, onMouseLeave: stopPropagation, children: _jsx("div", { style: { background: isExternalNode ? "rgb(240, 240, 240)" : undefined }, children: _jsx(TypeRefSelector, { zoom: 0.8, heightRef: dmnEditorRootElementRef, typeRef: resolvedTypeRef, onChange: props.onChange, onCreate: props.onCreate, onToggle: props.onToggle, menuAppendTo: "parent", isDisabled: isExternalNode || props.isReadOnly }) }) })) }));
}
//# sourceMappingURL=DataTypeNodePanel.js.map