import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { snapPoint } from "../SnapGrid";
import { PositionalNodeHandleId } from "../connections/PositionalNodeHandles";
import { getLineRectangleIntersectionPoint, getHandlePosition, pointsToPath } from "../maths/DmnMaths";
import { getBoundsCenterPoint } from "../maths/Maths";
import { getDiscretelyAutoPositionedEdgeParams } from "../maths/Maths";
import { AutoPositionedEdgeMarker } from "./AutoPositionedEdgeMarker";
export function getSnappedMultiPointAnchoredEdgePath({ snapGrid, dmnEdge, sourceNodeBounds, targetNodeBounds, dmnShapeSource, dmnShapeTarget, }) {
    var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
    var _l;
    if (!sourceNodeBounds || !targetNodeBounds) {
        return { path: undefined, points: [] };
    }
    const points = new Array(Math.max(2, (_b = (_a = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["di:waypoint"]) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0));
    const discreteAuto = getDiscretelyAutoPositionedEdgeParams(sourceNodeBounds, targetNodeBounds);
    if ((_c = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["@_id"]) === null || _c === void 0 ? void 0 : _c.endsWith(AutoPositionedEdgeMarker.BOTH)) {
        points[0] = { "@_x": discreteAuto.sx, "@_y": discreteAuto.sy };
        points[points.length - 1] = { "@_x": discreteAuto.tx, "@_y": discreteAuto.ty };
    }
    else if ((_d = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["@_id"]) === null || _d === void 0 ? void 0 : _d.endsWith(AutoPositionedEdgeMarker.SOURCE)) {
        points[0] = { "@_x": discreteAuto.sx, "@_y": discreteAuto.sy };
    }
    else if ((_e = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["@_id"]) === null || _e === void 0 ? void 0 : _e.endsWith(AutoPositionedEdgeMarker.TARGET)) {
        points[points.length - 1] = { "@_x": discreteAuto.tx, "@_y": discreteAuto.ty };
    }
    if (!(dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["di:waypoint"])) {
        console.warn("DMN DIAGRAM: No waypoints found. Creating a default straight line.");
        points[0] = { "@_x": discreteAuto.sx, "@_y": discreteAuto.sy };
        points[points.length - 1] = { "@_x": discreteAuto.tx, "@_y": discreteAuto.ty };
    }
    else if ((dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["di:waypoint"].length) < 2) {
        console.warn("DMN DIAGRAM: Invalid waypoints for edge. Creating a default straight line.");
        points[0] = { "@_x": discreteAuto.sx, "@_y": discreteAuto.sy };
        points[points.length - 1] = { "@_x": discreteAuto.tx, "@_y": discreteAuto.ty };
    }
    else {
        const firstWaypoint = dmnEdge["di:waypoint"][0];
        const secondWaypoint = (_f = points[1]) !== null && _f !== void 0 ? _f : dmnEdge["di:waypoint"][1];
        const sourceHandlePoint = getSnappedHandlePosition(dmnShapeSource, sourceNodeBounds, firstWaypoint, points.length === 2 ? getBoundsCenterPoint(targetNodeBounds) : snapPoint(snapGrid, secondWaypoint));
        (_g = points[0]) !== null && _g !== void 0 ? _g : (points[0] = sourceHandlePoint);
        const lastWaypoint = dmnEdge["di:waypoint"][dmnEdge["di:waypoint"].length - 1];
        const secondToLastWaypoint = (_h = points[points.length - 2]) !== null && _h !== void 0 ? _h : dmnEdge["di:waypoint"][dmnEdge["di:waypoint"].length - 2];
        const targetHandlePoint = getSnappedHandlePosition(dmnShapeTarget, targetNodeBounds, lastWaypoint, points.length === 2 ? getBoundsCenterPoint(sourceNodeBounds) : snapPoint(snapGrid, secondToLastWaypoint));
        (_j = points[_l = points.length - 1]) !== null && _j !== void 0 ? _j : (points[_l] = targetHandlePoint);
    }
    for (let i = 1; i < points.length - 1; i++) {
        points[i] = snapPoint(snapGrid, { ...((_k = dmnEdge === null || dmnEdge === void 0 ? void 0 : dmnEdge["di:waypoint"]) !== null && _k !== void 0 ? _k : [])[i] });
    }
    return { path: pointsToPath(points), points };
}
export function getSnappedHandlePosition(shape, snappedNode, originalHandleWaypoint, snappedSecondWaypoint) {
    var _a, _b, _c, _d;
    const { handlePosition } = getHandlePosition({ shapeBounds: shape["dc:Bounds"], waypoint: originalHandleWaypoint });
    const centerHandleWaypoint = getBoundsCenterPoint(snappedNode);
    const nodeRectangle = {
        x: (_a = snappedNode.x) !== null && _a !== void 0 ? _a : 0,
        y: (_b = snappedNode.y) !== null && _b !== void 0 ? _b : 0,
        width: (_c = snappedNode.width) !== null && _c !== void 0 ? _c : 0,
        height: (_d = snappedNode.height) !== null && _d !== void 0 ? _d : 0,
    };
    return switchExpression(handlePosition, {
        [PositionalNodeHandleId.Top]: { "@_x": nodeRectangle.x + nodeRectangle.width / 2, "@_y": nodeRectangle.y },
        [PositionalNodeHandleId.Right]: {
            "@_x": nodeRectangle.x + nodeRectangle.width,
            "@_y": nodeRectangle.y + nodeRectangle.height / 2,
        },
        [PositionalNodeHandleId.Bottom]: {
            "@_x": nodeRectangle.x + nodeRectangle.width / 2,
            "@_y": nodeRectangle.y + nodeRectangle.height,
        },
        [PositionalNodeHandleId.Left]: { "@_x": nodeRectangle.x, "@_y": nodeRectangle.y + nodeRectangle.height / 2 },
        [PositionalNodeHandleId.Center]: getLineRectangleIntersectionPoint(snappedSecondWaypoint, centerHandleWaypoint, nodeRectangle),
    });
}
//# sourceMappingURL=getSnappedMultiPointAnchoredEdgePath.js.map