import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import * as RF from "reactflow";
import * as React from "react";
import { useCallback } from "react";
import { NODE_TYPES } from "./nodes/NodeTypes";
import { DiagramLhsPanel } from "../store/Store";
import { useDmnEditorStore, useDmnEditorStoreApi } from "../store/StoreContext";
import { addStandaloneNode } from "../mutations/addStandaloneNode";
import { CONTAINER_NODES_DESIRABLE_PADDING, getBounds } from "./maths/DmnMaths";
import { Popover } from "@patternfly/react-core/dist/js/components/Popover";
import { ExternalNodesPanel } from "../externalNodes/ExternalNodesPanel";
import { MigrationIcon } from "@patternfly/react-icons/dist/js/icons/migration-icon";
import { AlternativeInputDataIcon, BkmIcon, DecisionIcon, DecisionServiceIcon, GroupIcon, InputDataIcon, KnowledgeSourceIcon, TextAnnotationIcon, } from "../icons/Icons";
import { DrdSelectorPanel } from "./DrdSelectorPanel";
import { addOrGetDrd, getDefaultDrdName } from "../mutations/addOrGetDrd";
import { InlineFeelNameInput } from "../feel/InlineFeelNameInput";
import { BarsIcon } from "@patternfly/react-icons/dist/js/icons/bars-icon";
import { DrgNodesPanel } from "./DrgNodesPanel";
import { CaretDownIcon } from "@patternfly/react-icons/dist/js/icons/caret-down-icon";
import { useInViewSelect } from "../responsiveness/useInViewSelect";
import { useDmnEditor } from "../DmnEditorContext";
import { getDrdId } from "./drd/drdId";
import { useSettings } from "../settings/DmnEditorSettingsContext";
import { useExternalModels } from "../includedModels/DmnEditorDependenciesContext";
export const MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE = "application/kie-dmn-editor--new-node-from-palette";
export function Palette({ pulse }) {
    var _a, _b, _c;
    const onDragStart = useCallback((event, nodeType) => {
        event.dataTransfer.setData(MIME_TYPE_FOR_DMN_EDITOR_NEW_NODE_FROM_PALETTE, nodeType);
        event.dataTransfer.effectAllowed = "move";
    }, []);
    const { dmnEditorRootElementRef } = useDmnEditor();
    const dmnEditorStoreApi = useDmnEditorStoreApi();
    const diagram = useDmnEditorStore((s) => s.diagram);
    const thisDmn = useDmnEditorStore((s) => s.dmn.model);
    const rfStoreApi = RF.useStoreApi();
    const isAlternativeInputDataShape = useDmnEditorStore((s) => s.computed(s).isAlternativeInputDataShape());
    const drdIndex = useDmnEditorStore((s) => s.computed(s).getDrdIndex());
    const { externalModelsByNamespace } = useExternalModels();
    const settings = useSettings();
    const groupNodes = useCallback(() => {
        dmnEditorStoreApi.setState((state) => {
            const selectedNodes = rfStoreApi
                .getState()
                .getNodes()
                .filter((s) => s.selected);
            if (selectedNodes.length <= 0) {
                return;
            }
            const { href: newNodeId } = addStandaloneNode({
                definitions: state.dmn.model.definitions,
                drdIndex: state.computed(state).getDrdIndex(),
                newNode: {
                    type: NODE_TYPES.group,
                    bounds: getBounds({
                        nodes: selectedNodes,
                        padding: CONTAINER_NODES_DESIRABLE_PADDING,
                    }),
                },
                externalModelsByNamespace,
            });
            state.dispatch(state).diagram.setNodeStatus(newNodeId, { selected: true });
        });
    }, [dmnEditorStoreApi, externalModelsByNamespace, rfStoreApi]);
    const drd = (_b = (_a = thisDmn.definitions["dmndi:DMNDI"]) === null || _a === void 0 ? void 0 : _a["dmndi:DMNDiagram"]) === null || _b === void 0 ? void 0 : _b[drdIndex];
    const drdSelectorPopoverRef = React.useRef(null);
    const nodesPalletePopoverRef = React.useRef(null);
    const { maxHeight } = useInViewSelect(dmnEditorRootElementRef, nodesPalletePopoverRef);
    const clearCurrentFocusToAllowDraggingNewNode = useCallback(() => {
        var _a, _b;
        (_b = (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur) === null || _b === void 0 ? void 0 : _b.call(_a);
    }, []);
    return (_jsxs(_Fragment, { children: [_jsx(RF.Panel, { position: "top-left", children: _jsxs("aside", { "data-testid": "kie-tools--dmn-editor--drd-selector", className: "kie-dmn-editor--drd-selector", style: { position: "relative" }, children: [_jsx("div", { ref: drdSelectorPopoverRef, style: { position: "absolute", left: "56px", height: "100%", zIndex: -1 } }), _jsx(InlineFeelNameInput, { validate: () => true, allUniqueNames: () => new Map(), name: (_c = drd === null || drd === void 0 ? void 0 : drd["@_name"]) !== null && _c !== void 0 ? _c : "", prefix: `${drdIndex + 1}.`, id: getDrdId({ drdIndex: drdIndex }), onRenamed: (newName) => {
                                dmnEditorStoreApi.setState((state) => {
                                    const drd = addOrGetDrd({
                                        definitions: state.dmn.model.definitions,
                                        drdIndex: state.computed(state).getDrdIndex(),
                                    });
                                    drd.diagram["@_name"] = newName;
                                });
                            }, placeholder: getDefaultDrdName({ drdIndex: drdIndex }), isReadOnly: settings.isReadOnly, isPlain: true, shouldCommitOnBlur: true }), _jsx(Popover, { className: "kie-dmn-editor--drd-selector-popover", "aria-label": "DRD Selector Popover", isVisible: diagram.openLhsPanel === DiagramLhsPanel.DRD_SELECTOR, reference: () => drdSelectorPopoverRef.current, shouldClose: () => {
                                dmnEditorStoreApi.setState((state) => {
                                    state.diagram.openLhsPanel = DiagramLhsPanel.NONE;
                                });
                            }, showClose: false, position: "bottom-start", hideOnOutsideClick: false, bodyContent: _jsx(DrdSelectorPanel, {}) }, DiagramLhsPanel.DRD_SELECTOR), _jsx("button", { title: "Select or edit DRD", onClick: () => {
                                dmnEditorStoreApi.setState((state) => {
                                    state.diagram.openLhsPanel =
                                        state.diagram.openLhsPanel === DiagramLhsPanel.DRD_SELECTOR
                                            ? DiagramLhsPanel.NONE
                                            : DiagramLhsPanel.DRD_SELECTOR;
                                });
                            }, children: _jsx(CaretDownIcon, {}) })] }) }), !settings.isReadOnly && (_jsxs(RF.Panel, { position: "top-left", style: { marginTop: "78px" }, onMouseDownCapture: clearCurrentFocusToAllowDraggingNewNode, children: [_jsx("div", { ref: nodesPalletePopoverRef, style: { position: "absolute", left: 0, height: 0, zIndex: -1 } }), _jsxs("aside", { className: `kie-dmn-editor--palette ${pulse ? "pulse" : ""}`, children: [_jsx("div", { title: "Input Data", className: "kie-dmn-editor--palette-button dndnode input-data", onDragStart: (event) => onDragStart(event, NODE_TYPES.inputData), draggable: true, children: isAlternativeInputDataShape ? _jsx(AlternativeInputDataIcon, {}) : _jsx(InputDataIcon, {}) }), _jsx("div", { title: "Decision", className: "kie-dmn-editor--palette-button dndnode decision", onDragStart: (event) => onDragStart(event, NODE_TYPES.decision), draggable: true, children: _jsx(DecisionIcon, {}) }), _jsx("div", { title: "Business Knowledge Model", className: "kie-dmn-editor--palette-button dndnode bkm", onDragStart: (event) => onDragStart(event, NODE_TYPES.bkm), draggable: true, children: _jsx(BkmIcon, {}) }), _jsx("div", { title: "Knowledge Source", className: "kie-dmn-editor--palette-button dndnode knowledge-source", onDragStart: (event) => onDragStart(event, NODE_TYPES.knowledgeSource), draggable: true, children: _jsx(KnowledgeSourceIcon, {}) }), _jsx("div", { title: "Decision Service", className: "kie-dmn-editor--palette-button dndnode decision-service", onDragStart: (event) => onDragStart(event, NODE_TYPES.decisionService), draggable: true, children: _jsx(DecisionServiceIcon, {}) })] }), _jsx("br", {}), _jsxs("aside", { className: `kie-dmn-editor--palette ${pulse ? "pulse" : ""}`, children: [_jsx("div", { title: "Group", className: "kie-dmn-editor--palette-button dndnode group", onDragStart: (event) => onDragStart(event, NODE_TYPES.group), draggable: true, onClick: groupNodes, children: _jsx(GroupIcon, {}) }), _jsx("div", { title: "Text Annotation", className: "kie-dmn-editor--palette-button dndnode text-annotation", onDragStart: (event) => onDragStart(event, NODE_TYPES.textAnnotation), draggable: true, children: _jsx(TextAnnotationIcon, {}) })] }), _jsx("br", {}), _jsxs("aside", { className: "kie-dmn-editor--drg-panel-toggle", children: [diagram.openLhsPanel === DiagramLhsPanel.DRG_NODES && (_jsx("div", { "data-testid": "kie-tools--dmn-editor--palette-nodes-popover", className: "kie-dmn-editor--palette-nodes-popover", style: { maxHeight }, children: _jsx(DrgNodesPanel, {}) })), _jsx("button", { title: "DRG nodes", className: `kie-dmn-editor--drg-panel-toggle-button ${diagram.openLhsPanel === DiagramLhsPanel.DRG_NODES ? "active" : ""}`, onClick: () => {
                                    dmnEditorStoreApi.setState((state) => {
                                        state.diagram.openLhsPanel =
                                            state.diagram.openLhsPanel === DiagramLhsPanel.DRG_NODES
                                                ? DiagramLhsPanel.NONE
                                                : DiagramLhsPanel.DRG_NODES;
                                    });
                                }, children: _jsx(BarsIcon, { size: "sm" }) })] }), _jsx("br", {}), _jsxs("aside", { className: "kie-dmn-editor--external-nodes-panel-toggle", children: [diagram.openLhsPanel === DiagramLhsPanel.EXTERNAL_NODES && (_jsx("div", { className: "kie-dmn-editor--palette-nodes-popover", style: { maxHeight }, "data-testid": "kie-tools--dmn-editor--external-nodes-popover", children: _jsx(ExternalNodesPanel, {}) })), _jsx("button", { title: "External nodes", className: `kie-dmn-editor--external-nodes-panel-toggle-button ${diagram.openLhsPanel === DiagramLhsPanel.EXTERNAL_NODES ? "active" : ""}`, onClick: () => {
                                    dmnEditorStoreApi.setState((state) => {
                                        state.diagram.openLhsPanel =
                                            state.diagram.openLhsPanel === DiagramLhsPanel.EXTERNAL_NODES
                                                ? DiagramLhsPanel.NONE
                                                : DiagramLhsPanel.EXTERNAL_NODES;
                                    });
                                }, children: _jsx(MigrationIcon, { size: "sm" }) })] })] }))] }));
}
//# sourceMappingURL=Palette.js.map