import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useRef, useState } from "react";
import { TimePicker } from "@patternfly/react-core/dist/js/components/TimePicker";
import "./Constraint.css";
import "./ConstraintTime.css";
import { Select, SelectOption, SelectVariant } from "@patternfly/react-core/dist/js/components/Select";
import { useDmnEditor } from "../../DmnEditorContext";
import { useInViewSelect } from "../../responsiveness/useInViewSelect";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import moment from "moment";
const UTC_POSITEVE_TIMEZONES = [
    "+00:00",
    "+01:00",
    "+02:00",
    "+03:00",
    "+03:30",
    "+04:00",
    "+04:30",
    "+05:00",
    "+05:30",
    "+05:45",
    "+06:00",
    "+06:30",
    "+07:00",
    "+08:00",
    "+08:30",
    "+08:45",
    "+09:00",
    "+09:30",
    "+10:00",
    "+10:30",
    "+11:00",
    "+12:00",
    "+12:45",
    "+13:00",
    "+13:45",
    "+14:00",
];
const UTC_NEGATIVE_TIMEZONES = [
    "-12:00",
    "-11:00",
    "-10:00",
    "-09:30",
    "-09:00",
    "-08:00",
    "-07:00",
    "-06:00",
    "-05:00",
    "-04:00",
    "-03:30",
    "-03:00",
    "-02:30",
    "-02:00",
    "-01:00",
];
const TIME_REGEXP = /^(0[0-9]|1[0-9]|2[0-3]):[0-5][0-9](:[0-5][0-9])?([+|-](0[0-9]|1[0-9]|2[0-3]):[0-9][0-9])?$/;
export function ConstraintTime({ value, onChange, isValid }) {
    const time = useMemo(() => {
        if (value.match(TIME_REGEXP) === null) {
            return "";
        }
        return value.includes("+") ? value.split("+")[0] : value.split("-")[0];
    }, [value]);
    const timezone = useMemo(() => {
        if (value.match(TIME_REGEXP) === null) {
            return UTC_POSITEVE_TIMEZONES[0];
        }
        return value.includes("+")
            ? `+${value.split("+")[1]}`
            : value.includes("-")
                ? `-${value.split("-")[1]}`
                : UTC_POSITEVE_TIMEZONES[0];
    }, [value]);
    const [isSelectTimezoneOpen, setSelectTimezoneOpen] = useState(false);
    const { dmnEditorRootElementRef } = useDmnEditor();
    const toggleRef = useRef(null);
    const inViewTimezoneSelect = useInViewSelect(dmnEditorRootElementRef, toggleRef);
    const onInternalChange = useCallback((args) => {
        var _a, _b;
        const newTime = (_a = args.time) !== null && _a !== void 0 ? _a : time;
        const newTimezone = (_b = args.timezone) !== null && _b !== void 0 ? _b : timezone;
        if (newTime !== "" && newTimezone !== "") {
            onChange(`${newTime}${newTimezone}`);
        }
    }, [onChange, time, timezone]);
    const onChangeTime = useCallback((value) => {
        onInternalChange({ time: value });
    }, [onInternalChange]);
    const onSelectTimezone = useCallback((e, value) => {
        onInternalChange({ timezone: value.toString() });
    }, [onInternalChange]);
    return (_jsxs("div", { children: [_jsx(TimePicker, { is24Hour: true, className: `kie-dmn-editor--constraint-time kie-dmn-editor--constraint-input ${isValid ? "" : "kie-dmn-editor--constraint-invalid"}`, inputProps: {
                    className: "kie-dmn-editor--constraint-input",
                    onBlur: (e) => {
                        if (moment(value, "HH:mm", true).isValid() || moment(value, "HH:mm:ss", true).isValid()) {
                            onChangeTime(value);
                        }
                    },
                }, time: time, onChange: (e, value) => {
                    if (moment(value, "HH:mm", true).isValid()) {
                        onChangeTime(`${value}:00`);
                    }
                    if (moment(value, "HH:mm:ss", true).isValid()) {
                        onChangeTime(value);
                    }
                }, includeSeconds: true }), time === "" ? (_jsx(Tooltip, { content: "To tweak the timezone it's necessary to set a time first", children: _jsx(Select, { className: "kie-dmn-editor--constraint-time-timezone", variant: SelectVariant.single, onToggle: () => { }, selections: UTC_POSITEVE_TIMEZONES[0], isOpen: false, isDisabled: true, isPlain: true, children: [_jsx(SelectOption, { value: UTC_POSITEVE_TIMEZONES[0] }, UTC_POSITEVE_TIMEZONES[0])] }) })) : (_jsx(Select, { toggleRef: toggleRef, className: `kie-dmn-editor--constraint-time-timezone ${isValid ? "" : "kie-dmn-editor--constraint-time-timezone-invalid"}`, variant: SelectVariant.single, placeholderText: "Select timezone", "aria-label": "Select timezone", onToggle: (isExpanded) => setSelectTimezoneOpen(isExpanded), onSelect: onSelectTimezone, selections: timezone, isOpen: isSelectTimezoneOpen, isDisabled: false, isPlain: true, maxHeight: inViewTimezoneSelect.maxHeight, direction: inViewTimezoneSelect.direction, children: [...UTC_NEGATIVE_TIMEZONES, ...UTC_POSITEVE_TIMEZONES].map((timezone) => (_jsx(SelectOption, { value: timezone }, timezone))) }))] }));
}
//# sourceMappingURL=ConstraintTime.js.map