"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Subscribable = void 0;
var Subscribable = (function () {
    function Subscribable(args) {
        this.args = args;
        this.subscriptions = new Set();
    }
    Subscribable.prototype.subscribe = function (subscription) {
        this.subscriptions.add(subscription);
        return subscription;
    };
    Subscribable.prototype.unsubscribe = function (subscription) {
        this.subscriptions.delete(subscription);
    };
    Subscribable.prototype._notifySubscribers = function () {
        var newValue = this.args.newValueSupplier();
        this.subscriptions.forEach(function (subscription) {
            subscription(newValue);
        });
    };
    return Subscribable;
}());
exports.Subscribable = Subscribable;
//# sourceMappingURL=Subscribable.js.map