import { KieSandboxWorkspacesFs } from "./KieSandboxWorkspaceFs";
import { FsSchema } from "./FsCache";
export declare class StorageFile {
    private readonly args;
    constructor(args: {
        path: string;
        getFileContents: () => Promise<Uint8Array>;
    });
    get path(): string;
    get getFileContents(): () => Promise<Uint8Array>;
}
export declare class StorageService {
    createOrOverwriteFile(fs: KieSandboxWorkspacesFs, file: StorageFile): Promise<void>;
    updateFile(fs: KieSandboxWorkspacesFs, path: string, getFileContents: () => Promise<Uint8Array>): Promise<void>;
    deleteFile(fs: KieSandboxWorkspacesFs, path: string): Promise<void>;
    renameFile(fs: KieSandboxWorkspacesFs, file: StorageFile, newFileName: string): Promise<StorageFile>;
    moveFile(fs: KieSandboxWorkspacesFs, file: StorageFile, newDirPath: string): Promise<StorageFile>;
    moveFiles(fs: KieSandboxWorkspacesFs, files: StorageFile[], newDirPath: string): Promise<Map<string, string>>;
    getFileContent(fs: KieSandboxWorkspacesFs, path: string): Promise<Uint8Array>;
    getFile(fs: KieSandboxWorkspacesFs, path: string): Promise<StorageFile | undefined>;
    mkdirDeep(fs: KieSandboxWorkspacesFs, dirPath: string, _selfCall?: boolean): Promise<void>;
    exists(fs: KieSandboxWorkspacesFs, path: string): Promise<boolean>;
    walk<T = string>(args: {
        schema: FsSchema;
        baseAbsolutePath: string;
        shouldExcludeAbsolutePath: (dirPath: string) => boolean;
        onVisit: (args: {
            absolutePath: string;
            relativePath: string;
        }) => Promise<T | undefined>;
    }): Promise<T[]>;
}
//# sourceMappingURL=StorageService.d.ts.map