"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FsService = exports.Broadcaster = exports.Broadcastee = void 0;
var FsCache_1 = require("./FsCache");
var FsUsageCounter_1 = require("./FsUsageCounter");
var FsUnloadManager_1 = require("./FsUnloadManager");
var Broadcastee = (function () {
    function Broadcastee() {
    }
    Broadcastee.prototype.watch = function (args) { };
    Broadcastee.prototype.dispose = function () { };
    return Broadcastee;
}());
exports.Broadcastee = Broadcastee;
var Broadcaster = (function () {
    function Broadcaster() {
    }
    Broadcaster.prototype.broadcast = function (args) {
        return __awaiter(this, void 0, void 0, function () {
            var bc, _a, _b;
            return __generator(this, function (_c) {
                switch (_c.label) {
                    case 0:
                        bc = new BroadcastChannel(args.channel);
                        _b = (_a = bc).postMessage;
                        return [4, args.message()];
                    case 1:
                        _b.apply(_a, [_c.sent()]);
                        bc.close();
                        return [2];
                }
            });
        });
    };
    return Broadcaster;
}());
exports.Broadcaster = Broadcaster;
var DEFAULT_FS_FLUSH_DEBOUNCE_TIMEOUT_IN_MS = 100;
var BIG_FS_FLUSH_DEBOUNCE_TIMEOUT_IN_MS = 500;
var BIG_FS_SIZE_IN_ENTRIES_COUNT = 1000;
var FsService = (function () {
    function FsService(args, fsFlushManager, readWriteFsUsageCounter, readonlyFsUsageCounter, fsCache, fsUnloadManager) {
        if (readWriteFsUsageCounter === void 0) { readWriteFsUsageCounter = new FsUsageCounter_1.FsUsageCounter(); }
        if (readonlyFsUsageCounter === void 0) { readonlyFsUsageCounter = new FsUsageCounter_1.FsUsageCounter(); }
        if (fsCache === void 0) { fsCache = new FsCache_1.FsCache(); }
        if (fsUnloadManager === void 0) { fsUnloadManager = new FsUnloadManager_1.FsUnloadManager(fsCache, readWriteFsUsageCounter, readonlyFsUsageCounter, fsFlushManager); }
        this.args = args;
        this.fsFlushManager = fsFlushManager;
        this.readWriteFsUsageCounter = readWriteFsUsageCounter;
        this.readonlyFsUsageCounter = readonlyFsUsageCounter;
        this.fsCache = fsCache;
        this.fsUnloadManager = fsUnloadManager;
    }
    FsService.prototype.withReadonlyFsSchema = function (fsMountPoint, callback) {
        return __awaiter(this, void 0, void 0, function () {
            var schema;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.fsCache.getOrLoadFsSchema(fsMountPoint)];
                    case 1:
                        schema = _a.sent();
                        return [4, callback({ schema: schema })];
                    case 2: return [2, _a.sent()];
                }
            });
        });
    };
    FsService.prototype.withReadWriteInMemoryFs = function (fsMountPoint, callback) {
        return __awaiter(this, void 0, void 0, function () {
            var schema, fs, usagesLeft, didTriggerUnload, debounceTimeoutInMs;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.fsUnloadManager.makeSpaceForOrWaitUnloadOf(fsMountPoint)];
                    case 1:
                        _a.sent();
                        this.readWriteFsUsageCounter.addUsage(fsMountPoint);
                        return [4, this.fsCache.getOrLoadFsSchema(fsMountPoint)];
                    case 2:
                        schema = _a.sent();
                        return [4, this.fsCache.getOrLoadFs(fsMountPoint)];
                    case 3:
                        fs = _a.sent();
                        _a.label = 4;
                    case 4:
                        _a.trys.push([4, , 6, 12]);
                        this.fsFlushManager.pauseScheduledFlushIfScheduled(fsMountPoint);
                        return [4, callback({ fs: fs, schema: schema, broadcaster: new Broadcaster() })];
                    case 5: return [2, _a.sent()];
                    case 6:
                        usagesLeft = this.readWriteFsUsageCounter.releaseUsage(fsMountPoint).usagesLeft;
                        if (!(usagesLeft > 0)) return [3, 7];
                        console.log("[".concat(this.args.name, "] Skipping flush/unload for ").concat(fsMountPoint, ". (").concat(usagesLeft, " usages left.)"));
                        return [3, 11];
                    case 7:
                        didTriggerUnload = this.fsUnloadManager.unloadFsIfMarkedAndNotInUse(fsMountPoint).didTriggerUnload;
                        if (!didTriggerUnload) return [3, 8];
                        console.log("[".concat(this.args.name, "] Unload triggered for ").concat(fsMountPoint));
                        return [3, 11];
                    case 8:
                        console.log("[".concat(this.args.name, "] Requesting flush for ").concat(fsMountPoint));
                        return [4, this.getFlushDebounceTimeoutInMs(this.fsCache, fsMountPoint)];
                    case 9:
                        debounceTimeoutInMs = _a.sent();
                        return [4, this.fsFlushManager.requestFsFlush(this.fsCache, fsMountPoint, { debounceTimeoutInMs: debounceTimeoutInMs })];
                    case 10:
                        _a.sent();
                        _a.label = 11;
                    case 11: return [7];
                    case 12: return [2];
                }
            });
        });
    };
    FsService.prototype.withReadonlyInMemoryFs = function (fsMountPoint, callback) {
        return __awaiter(this, void 0, void 0, function () {
            var schema, fs;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, this.fsUnloadManager.makeSpaceForOrWaitUnloadOf(fsMountPoint)];
                    case 1:
                        _a.sent();
                        this.readonlyFsUsageCounter.addUsage(fsMountPoint);
                        return [4, this.fsCache.getOrLoadFsSchema(fsMountPoint)];
                    case 2:
                        schema = _a.sent();
                        return [4, this.fsCache.getOrLoadFs(fsMountPoint)];
                    case 3:
                        fs = _a.sent();
                        _a.label = 4;
                    case 4:
                        _a.trys.push([4, , 6, 7]);
                        return [4, callback({ fs: this.getReadonlyFs(fsMountPoint, fs), schema: schema })];
                    case 5: return [2, _a.sent()];
                    case 6:
                        this.readonlyFsUsageCounter.releaseUsage(fsMountPoint);
                        this.fsUnloadManager.unloadFsIfMarkedAndNotInUse(fsMountPoint);
                        return [7];
                    case 7: return [2];
                }
            });
        });
    };
    FsService.prototype.getReadonlyFs = function (fsMountPoint, readWriteFs) {
        var _this = this;
        var throwCantMutateReadonlyFsException = function () { return __awaiter(_this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                throw new Error("[".concat(this.args.name, "] Can't mutate read-only FS - ").concat(fsMountPoint));
            });
        }); };
        return {
            promises: {
                writeFile: throwCantMutateReadonlyFsException,
                unlink: throwCantMutateReadonlyFsException,
                mkdir: throwCantMutateReadonlyFsException,
                rmdir: throwCantMutateReadonlyFsException,
                symlink: throwCantMutateReadonlyFsException,
                chmod: throwCantMutateReadonlyFsException,
                rename: throwCantMutateReadonlyFsException,
                readFile: function (path, options) { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2, readWriteFs.promises.readFile(path, options)];
                    });
                }); },
                readdir: function (path, options) { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2, readWriteFs.promises.readdir(path, options)];
                    });
                }); },
                stat: function (path) { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2, readWriteFs.promises.stat(path)];
                    });
                }); },
                lstat: function (path) { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2, readWriteFs.promises.lstat(path)];
                    });
                }); },
                readlink: function (path, options) { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2, readWriteFs.promises.readlink(path, options)];
                    });
                }); },
            },
        };
    };
    FsService.prototype.getFlushDebounceTimeoutInMs = function (fsCache, fsMountPoint) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4, fsCache.getOrLoadFsSchema(fsMountPoint)];
                    case 1:
                        if ((_a.sent()).size > BIG_FS_SIZE_IN_ENTRIES_COUNT) {
                            return [2, BIG_FS_FLUSH_DEBOUNCE_TIMEOUT_IN_MS];
                        }
                        else {
                            return [2, DEFAULT_FS_FLUSH_DEBOUNCE_TIMEOUT_IN_MS];
                        }
                        return [2];
                }
            });
        });
    };
    return FsService;
}());
exports.FsService = FsService;
//# sourceMappingURL=FsService.js.map