import AjvDraft04 from "ajv-draft-04";
import addFormats from "ajv-formats";
import { UnitablesJsonSchemaBridge } from "./uniforms";
export class UnitablesValidator {
    constructor(i18n) {
        this.i18n = i18n;
        this.ajv = new AjvDraft04({ allErrors: true, useDefaults: true });
        addFormats(this.ajv);
    }
    createValidator(formSchema) {
        const validator = this.ajv.compile(formSchema);
        return (model) => {
            validator(JSON.parse(JSON.stringify(model)));
            if (validator.errors && validator.errors.length) {
                return { details: validator.errors };
            }
            return null;
        };
    }
    getBridge(formSchema) {
        return new UnitablesJsonSchemaBridge(formSchema, this.createValidator(formSchema), this.i18n);
    }
}
//# sourceMappingURL=UnitablesValidator.js.map