import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useEffect, useMemo, useState } from "react";
import * as __path from "path";
import { imperativePromiseHandle, } from "@kie-tools-core/react-hooks/dist/useImperativePromiseHandler";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
import { SearchType } from "@kie-tools-core/workspace/dist/api";
import { domParser } from "@kie-tools/xml-parser-ts";
import { normalize } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { getMarshaller as getDmnMarshaller } from "@kie-tools/dmn-marshaller";
import * as TestScenarioEditor from "@kie-tools/scesim-editor/dist/TestScenarioEditor";
import { getMarshaller } from "@kie-tools/scesim-marshaller";
import { EMPTY_ONE_EIGHT } from "@kie-tools/scesim-editor/dist/resources/EmptyScesimFile";
export const DMN_MODELS_SEARCH_GLOB_PATTERN = "**/*.dmn";
export const TARGET_DIRECTORY = "target/classes/";
export class TestScenarioEditorRoot extends React.Component {
    constructor(props) {
        super(props);
        this.externalModelsManagerDoneBootstraping = imperativePromiseHandle();
        this.setExternalModelsByNamespace = (externalModelsByNamespace) => {
            this.setState((prev) => ({ ...prev, externalModelsByNamespace }));
        };
        this.onModelChange = (model) => {
            this.setState((prev) => {
                const newStack = prev.stack.slice(0, prev.pointer + 1);
                return {
                    ...prev,
                    stack: [...newStack, model],
                    pointer: newStack.length,
                };
            }, () => this.props.onNewEdit({
                id: `${this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot}__${generateUuid()}`,
            }));
        };
        this.onRequestExternalModelsAvailableToInclude = async () => {
            if (!this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                return [];
            }
            const list = await this.props.onRequestWorkspaceFilesList({
                pattern: DMN_MODELS_SEARCH_GLOB_PATTERN,
                opts: { type: SearchType.TRAVERSAL },
            });
            return list.normalizedPosixPathsRelativeToTheWorkspaceRoot.flatMap((p) => p.includes(TARGET_DIRECTORY)
                ? []
                : __path.relative(__path.dirname(this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot), p));
        };
        this.onRequestToResolvePathRelativeToTheOpenFile = (normalizedPosixPathRelativeToTheOpenFile) => {
            const normalizedPosixPathRelativeToTheWorkspaceRoot = __path
                .resolve(__path.dirname(this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot), normalizedPosixPathRelativeToTheOpenFile)
                .substring(1);
            return normalizedPosixPathRelativeToTheWorkspaceRoot;
        };
        this.onRequestExternalModelByPathsRelativeToTheOpenFile = async (normalizedPosixPathRelativeToTheOpenFile) => {
            var _a;
            const normalizedPosixPathRelativeToTheWorkspaceRoot = this.onRequestToResolvePathRelativeToTheOpenFile(normalizedPosixPathRelativeToTheOpenFile);
            const resource = await this.props.onRequestWorkspaceFileContent({
                normalizedPosixPathRelativeToTheWorkspaceRoot,
                opts: { type: "text" },
            });
            const ext = __path.extname(normalizedPosixPathRelativeToTheOpenFile);
            if (ext === ".dmn") {
                return {
                    normalizedPosixPathRelativeToTheOpenFile,
                    type: "dmn",
                    model: normalize(getDmnMarshaller((_a = resource === null || resource === void 0 ? void 0 : resource.content) !== null && _a !== void 0 ? _a : "", { upgradeTo: "latest" }).parser.parse()),
                    svg: "",
                };
            }
            else {
                throw new Error(`Unknown extension '${ext}'.`);
            }
        };
        this.onOpenFileFromPathRelativeToTheOpenFile = (normalizedPosixPathRelativeToTheOpenFile) => {
            if (!this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                return;
            }
            this.props.onOpenFileFromNormalizedPosixPathRelativeToTheWorkspaceRoot(this.onRequestToResolvePathRelativeToTheOpenFile(normalizedPosixPathRelativeToTheOpenFile));
        };
        props.exposing(this);
        this.testScenarioEditorRef = React.createRef();
        this.state = {
            externalModelsByNamespace: new Map(),
            externalModelsManagerDoneBootstraping: false,
            isReadOnly: props.isReadOnly,
            keyboardShortcutsRegisterIds: [],
            keyboardShortcutsRegistred: false,
            marshaller: undefined,
            openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: undefined,
            pointer: -1,
            stack: [],
        };
    }
    async undo() {
        this.setState((prev) => ({ ...prev, pointer: Math.max(0, prev.pointer - 1) }));
    }
    async redo() {
        this.setState((prev) => ({ ...prev, pointer: Math.min(prev.stack.length - 1, prev.pointer + 1) }));
    }
    async getDiagramSvg() {
        var _a;
        return (_a = this.testScenarioEditorRef.current) === null || _a === void 0 ? void 0 : _a.getDiagramSvg();
    }
    async getContent() {
        if (!this.state.marshaller || !this.model) {
            throw new Error(`Test Scenario EDITOR ROOT: Content has not been set yet. Throwing an error to prevent returning a "default" content.`);
        }
        return this.state.marshaller.builder.build(this.model);
    }
    async setContent(openFileNormalizedPosixPathRelativeToTheWorkspaceRoot, content) {
        const marshaller = getMarshaller(content || EMPTY_ONE_EIGHT);
        const scesimModel = marshaller.parser.parse();
        let savedStackPointer = [];
        this.setState((prev) => {
            savedStackPointer = [...prev.stack];
            return {
                stack: [scesimModel],
                openFileNormalizedPosixPathRelativeToTheWorkspaceRoot,
                pointer: 0,
            };
        });
        if (!scesimModel ||
            !scesimModel.ScenarioSimulationModel ||
            scesimModel.ScenarioSimulationModel["parsererror"]) {
            throw new Error("Impossibile to correctly parse the provided scesim file. Most likely, the XML structure of the file is invalid.");
        }
        await this.externalModelsManagerDoneBootstraping.promise;
        this.setState((prev) => {
            if (prev.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot ===
                openFileNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                const newStack = savedStackPointer.slice(0, prev.pointer + 1);
                return {
                    externalModelsManagerDoneBootstraping: true,
                    isReadOnly: prev.isReadOnly,
                    openFileNormalizedPosixPathRelativeToTheWorkspaceRoot,
                    marshaller,
                    pointer: newStack.length,
                    stack: [...newStack, marshaller.parser.parse()],
                };
            }
            else {
                return {
                    externalModelsManagerDoneBootstraping: true,
                    isReadOnly: prev.isReadOnly,
                    marshaller,
                    openFileNormalizedPosixPathRelativeToTheWorkspaceRoot,
                    pointer: 0,
                    stack: [marshaller.parser.parse()],
                };
            }
        });
    }
    get model() {
        return this.state.stack[this.state.pointer];
    }
    componentDidUpdate(prevProps, prevState, snapshot) {
        var _a, _b;
        if (this.props.keyboardShortcutsService === undefined || this.state.keyboardShortcutsRegistred === true) {
            return;
        }
        const commands = (_a = this.testScenarioEditorRef.current) === null || _a === void 0 ? void 0 : _a.getCommands();
        if (commands === undefined) {
            return;
        }
        const togglePropertiesPanel = (_b = this.props.keyboardShortcutsService) === null || _b === void 0 ? void 0 : _b.registerKeyPress("I", "Misc | Open/Close dock panel", async () => commands.toggleTestScenarioDock());
        this.setState((prev) => ({
            ...prev,
            keyboardShortcutsRegistred: true,
            keyboardShortcutsRegisterIds: [togglePropertiesPanel],
        }));
    }
    componentWillUnmount() {
        var _a;
        const keyboardShortcuts = (_a = this.testScenarioEditorRef.current) === null || _a === void 0 ? void 0 : _a.getCommands();
        if (keyboardShortcuts === undefined) {
            return;
        }
        this.state.keyboardShortcutsRegisterIds.forEach((id) => {
            var _a;
            (_a = this.props.keyboardShortcutsService) === null || _a === void 0 ? void 0 : _a.deregister(id);
        });
    }
    render() {
        return (_jsx(_Fragment, { children: this.model && (_jsxs(_Fragment, { children: [_jsx(TestScenarioEditor.TestScenarioEditor, { ref: this.testScenarioEditorRef, externalModelsByNamespace: this.state.externalModelsByNamespace, issueTrackerHref: "", model: this.model, onModelChange: this.onModelChange, onRequestExternalModelsAvailableToInclude: this.onRequestExternalModelsAvailableToInclude, onRequestExternalModelByPath: this.onRequestExternalModelByPathsRelativeToTheOpenFile, onRequestToJumpToPath: this.onOpenFileFromPathRelativeToTheOpenFile, onRequestToResolvePath: this.onRequestToResolvePathRelativeToTheOpenFile, openFileNormalizedPosixPathRelativeToTheWorkspaceRoot: this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot }), _jsx(ExternalModelsManager, { workspaceRootAbsolutePosixPath: this.props.workspaceRootAbsolutePosixPath, thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot: this.state.openFileNormalizedPosixPathRelativeToTheWorkspaceRoot, model: this.model, onChange: this.setExternalModelsByNamespace, onRequestWorkspaceFilesList: this.props.onRequestWorkspaceFilesList, onRequestWorkspaceFileContent: this.props.onRequestWorkspaceFileContent, externalModelsManagerDoneBootstraping: this.externalModelsManagerDoneBootstraping })] })) }));
    }
}
function ExternalModelsManager({ workspaceRootAbsolutePosixPath, thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot, model, onChange, onRequestWorkspaceFileContent, onRequestWorkspaceFilesList, externalModelsManagerDoneBootstraping, }) {
    var _a, _b;
    const targetNamespace = useMemo(() => {
        var _a, _b, _c;
        if ((_c = (_b = (_a = model.ScenarioSimulationModel) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.dmnNamespace) === null || _c === void 0 ? void 0 : _c.__$$text) {
            return model.ScenarioSimulationModel.settings.dmnNamespace.__$$text;
        }
        return null;
    }, [(_b = (_a = model.ScenarioSimulationModel) === null || _a === void 0 ? void 0 : _a.settings) === null || _b === void 0 ? void 0 : _b.dmnNamespace]);
    const [externalUpdatesCount, setExternalUpdatesCount] = useState(0);
    useEffect(() => {
        const bc = new BroadcastChannel("workspaces_files");
        bc.onmessage = ({ data }) => {
            if ((data === null || data === void 0 ? void 0 : data.relativePath) === thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot) {
                return;
            }
            if (!thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot &&
                __path.extname(thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot).toUpperCase() !== "dmn") {
                return;
            }
            setExternalUpdatesCount((prev) => prev + 1);
        };
        return () => {
            bc.close();
        };
    }, [thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot]);
    useEffect(() => {
        let canceled = false;
        if (!thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot) {
            return;
        }
        onRequestWorkspaceFilesList({ pattern: DMN_MODELS_SEARCH_GLOB_PATTERN, opts: { type: SearchType.TRAVERSAL } })
            .then((list) => {
            const resources = [];
            for (let i = 0; i < list.normalizedPosixPathsRelativeToTheWorkspaceRoot.length; i++) {
                const normalizedPosixPathRelativeToTheWorkspaceRoot = list.normalizedPosixPathsRelativeToTheWorkspaceRoot[i];
                if (normalizedPosixPathRelativeToTheWorkspaceRoot.includes(TARGET_DIRECTORY)) {
                    continue;
                }
                resources.push(onRequestWorkspaceFileContent({
                    normalizedPosixPathRelativeToTheWorkspaceRoot,
                    opts: { type: "text" },
                }));
            }
            return Promise.all(resources);
        })
            .then((resources) => {
            var _a;
            const externalModelsByNamespace = new Map();
            for (let i = 0; i < resources.length; i++) {
                const resource = resources[i];
                if (!resource) {
                    continue;
                }
                const content = (_a = resource.content) !== null && _a !== void 0 ? _a : "";
                const normalizedPosixPathRelativeToTheOpenFile = __path.relative(__path.dirname(thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot), resource.normalizedPosixPathRelativeToTheWorkspaceRoot);
                const ext = __path.extname(resource.normalizedPosixPathRelativeToTheWorkspaceRoot);
                if (ext === ".dmn") {
                    const namespace = domParser.getDomDocument(content).documentElement.getAttribute("namespace");
                    if (targetNamespace && namespace === targetNamespace) {
                        if (externalModelsByNamespace.has(namespace)) {
                            console.warn(`TEST SCENARIO EDITOR ROOT: Multiple DMN models encountered with the same namespace '${namespace}': '${resource.normalizedPosixPathRelativeToTheWorkspaceRoot}' and '${externalModelsByNamespace.get(namespace).normalizedPosixPathRelativeToTheOpenFile}'. The latter will be considered.`);
                        }
                        externalModelsByNamespace.set(namespace, {
                            normalizedPosixPathRelativeToTheOpenFile,
                            model: normalize(getDmnMarshaller(content, { upgradeTo: "latest" }).parser.parse()),
                            svg: "",
                        });
                    }
                }
                else {
                    throw new Error(`Unknown extension '${ext}'.`);
                }
            }
            if (targetNamespace && !externalModelsByNamespace.has(targetNamespace)) {
                externalModelsByNamespace.set(targetNamespace, undefined);
            }
            if (!canceled) {
                onChange(externalModelsByNamespace);
            }
            externalModelsManagerDoneBootstraping.resolve();
        });
        return () => {
            canceled = true;
        };
    }, [
        targetNamespace,
        onChange,
        onRequestWorkspaceFileContent,
        onRequestWorkspaceFilesList,
        thisScesimNormalizedPosixPathRelativeToTheWorkspaceRoot,
        externalUpdatesCount,
        workspaceRootAbsolutePosixPath,
        externalModelsManagerDoneBootstraping,
    ]);
    return _jsx(_Fragment, {});
}
//# sourceMappingURL=TestScenarioEditorRoot.js.map