import { EditorTheme } from "@kie-tools-core/editor/dist/api";
import { getOperatingSystem, OperatingSystem } from "@kie-tools-core/operating-system";
import { editor, KeyCode, KeyMod } from "monaco-editor";
import { FileLanguage } from "@kie-tools/json-yaml-language-service/dist/api";
export var RequestDataEditorOperation;
(function (RequestDataEditorOperation) {
    RequestDataEditorOperation[RequestDataEditorOperation["UNDO"] = 0] = "UNDO";
    RequestDataEditorOperation[RequestDataEditorOperation["REDO"] = 1] = "REDO";
    RequestDataEditorOperation[RequestDataEditorOperation["EDIT"] = 2] = "EDIT";
})(RequestDataEditorOperation || (RequestDataEditorOperation = {}));
export class RequestDataEditorController {
    constructor(content, onContentChange, isReadOnly) {
        this.onContentChange = onContentChange;
        this.isReadOnly = isReadOnly;
        this.model = editor.createModel(content, FileLanguage.JSON);
        this.model.onDidChangeContent((event) => {
            var _a;
            if (!event.isUndoing && !event.isRedoing) {
                (_a = this.editor) === null || _a === void 0 ? void 0 : _a.pushUndoStop();
                onContentChange({ content: this.model.getValue(), operation: RequestDataEditorOperation.EDIT });
            }
        });
    }
    redo() {
        var _a, _b;
        (_a = this.editor) === null || _a === void 0 ? void 0 : _a.focus();
        (_b = this.editor) === null || _b === void 0 ? void 0 : _b.trigger("editor", "redo", null);
    }
    undo() {
        var _a, _b;
        (_a = this.editor) === null || _a === void 0 ? void 0 : _a.focus();
        (_b = this.editor) === null || _b === void 0 ? void 0 : _b.trigger("editor", "undo", null);
    }
    setTheme(theme) {
        editor.setTheme(this.getMonacoThemeByEditorTheme(theme));
    }
    show(container, theme) {
        if (!container) {
            throw new Error("We need a container to show the editor!");
        }
        if (this.editor !== undefined) {
            this.setTheme(theme);
            return this.editor;
        }
        this.editor = editor.create(container, {
            model: this.model,
            language: FileLanguage.JSON,
            scrollBeyondLastLine: false,
            automaticLayout: true,
            fontSize: 14,
            theme: this.getMonacoThemeByEditorTheme(theme),
            readOnly: this.isReadOnly,
        });
        this.editor.addCommand(KeyMod.CtrlCmd | KeyCode.KeyZ, () => {
            this.onContentChange({ content: this.model.getValue(), operation: RequestDataEditorOperation.UNDO });
        });
        this.editor.addCommand(KeyMod.CtrlCmd | KeyMod.Shift | KeyCode.KeyZ, () => {
            this.onContentChange({ content: this.model.getValue(), operation: RequestDataEditorOperation.REDO });
        });
        if (getOperatingSystem() !== OperatingSystem.MACOS) {
            this.editor.addCommand(KeyMod.CtrlCmd | KeyCode.KeyY, () => {
                this.onContentChange({ content: this.model.getValue(), operation: RequestDataEditorOperation.REDO });
            });
        }
        return this.editor;
    }
    getContent() {
        var _a, _b;
        return ((_b = (_a = this.editor) === null || _a === void 0 ? void 0 : _a.getModel()) === null || _b === void 0 ? void 0 : _b.getValue()) || "";
    }
    setContent(content) {
        var _a, _b;
        (_b = (_a = this.editor) === null || _a === void 0 ? void 0 : _a.getModel()) === null || _b === void 0 ? void 0 : _b.setValue(content);
    }
    forceRedraw() {
        var _a;
        (_a = this.editor) === null || _a === void 0 ? void 0 : _a.render(true);
    }
    getMonacoThemeByEditorTheme(theme) {
        switch (theme) {
            case EditorTheme.DARK:
                return "vs-dark";
            case EditorTheme.HIGH_CONTRAST:
                return "hc-black";
            default:
                return "vs";
        }
    }
    dispose() {
        var _a;
        (_a = this.editor) === null || _a === void 0 ? void 0 : _a.dispose();
    }
}
//# sourceMappingURL=RequestDataEditorController.js.map