"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseXmlQName = parseXmlQName;
exports.buildXmlQName = buildXmlQName;
function parseXmlQName(qName) {
    var split = qName.split(":");
    if (split.length <= 1) {
        return { type: "xml-qname", localPart: qName };
    }
    if (split.length > 2) {
        throw new Error("XML QNames can't have colons (:) on neither the prefix or the localPart. Alledged QName: '".concat(qName, "'"));
    }
    return { type: "xml-qname", prefix: split[0], localPart: split[1] };
}
function buildXmlQName(_a) {
    var prefix = _a.prefix, localPart = _a.localPart;
    return prefix ? "".concat(prefix, ":").concat(localPart) : localPart;
}
//# sourceMappingURL=qNames.js.map