import { jsx as _jsx } from "react/jsx-runtime";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Gallery, GalleryItem } from "@patternfly/react-core/dist/js/layouts/Gallery";
import FormCard from "../FormCard/FormCard";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
const FormsGallery = ({ driver, formsData, isLoading, ouiaId, ouiaSafe }) => {
    if (isLoading) {
        return (_jsx(Bullseye, { children: _jsx(KogitoSpinner, { spinnerText: "Loading forms...", ouiaId: "forms-list-loading-forms" }) }));
    }
    if (!isLoading && formsData && formsData.length === 0) {
        return (_jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Search, title: "No results found", body: "Try using different filters" }));
    }
    return (_jsx(Gallery, { hasGutter: true, style: { margin: "25px" }, ...componentOuiaProps(ouiaId, "forms-gallery", ouiaSafe), children: formsData &&
            formsData.map((formData, index) => (_jsx(GalleryItem, { children: _jsx(FormCard, { formData: formData, driver: driver }, index) }, index))) }));
};
export default FormsGallery;
//# sourceMappingURL=FormsGallery.js.map