import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Helmet } from "react-helmet";
const ResourcesContainer = ({ resources }) => {
    const scriptTags = [];
    const styleTags = [];
    if (resources) {
        for (const key in resources.styles) {
            styleTags.push(_jsx("link", { rel: "stylesheet", href: resources.styles[key] }, key));
        }
        for (const key in resources.scripts) {
            scriptTags.push(_jsx("script", { src: resources.scripts[key], type: "text/javascript", async: false }, key));
        }
    }
    return (_jsxs(Helmet, { children: [styleTags, scriptTags] }));
};
export default ResourcesContainer;
//# sourceMappingURL=ResourcesContainer.js.map