import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useState } from "react";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStateVariant, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { ClipboardCopy, ClipboardCopyVariant } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { ExclamationCircleIcon } from "@patternfly/react-icons/dist/js/icons/exclamation-circle-icon";
import "@patternfly/patternfly/patternfly.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
const FormErrorsWrapper = ({ error, ouiaId, ouiaSafe }) => {
    const [expanded, setExpanded] = useState(false);
    const buildErrorTitle = () => {
        if (error.name && error.message) {
            return `${error.name}: ${error.message}`;
        }
        return error.toString();
    };
    const buildErrorInfo = () => {
        if (error.stack) {
            return error.stack;
        }
        return error.toString();
    };
    return (_jsx(Bullseye, { ...componentOuiaProps(ouiaId, "form-errors-wrapper", ouiaSafe), children: _jsxs(EmptyState, { variant: EmptyStateVariant.full, children: [_jsx(EmptyStateIcon, { icon: ExclamationCircleIcon }), _jsx(Title, { headingLevel: "h4", size: "lg", children: "Error displaying form:" }), _jsxs(EmptyStateBody, { children: [buildErrorTitle(), ".", " ", _jsx(Button, { variant: "link", isInline: true, onClick: () => setExpanded(!expanded), children: "See more details" })] }), expanded && (_jsx(EmptyStateBody, { children: _jsx(ClipboardCopy, { isCode: true, variant: ClipboardCopyVariant.expansion, isExpanded: true, children: _jsx("div", { className: "kogito-form-displayer-error-wrapper__align-left", children: buildErrorInfo() }) }) }))] }) }));
};
export default FormErrorsWrapper;
//# sourceMappingURL=FormErrorsWrapper.js.map