"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VsCodeOutputLogger = void 0;
var vscode = require("vscode");
var channel = vscode.window.createOutputChannel("KIE");
var VsCodeOutputLogger = (function () {
    function VsCodeOutputLogger(id) {
        this.id = id;
    }
    VsCodeOutputLogger.prototype.log = function (level, message) {
        var finalMessage = typeof message == "string" ? message : JSON.stringify(message, null, "\t");
        channel.appendLine("".concat(new Date().toISOString(), " [").concat(level.toUpperCase(), "] ").concat(this.id, ": ").concat(finalMessage));
    };
    VsCodeOutputLogger.prototype.info = function (message) {
        this.log("INFO", message);
    };
    VsCodeOutputLogger.prototype.warn = function (message) {
        this.log("WARN", message);
    };
    VsCodeOutputLogger.prototype.debug = function (message) {
        this.log("DEBUG", message);
    };
    VsCodeOutputLogger.prototype.error = function (message) {
        this.log("ERROR", message);
    };
    return VsCodeOutputLogger;
}());
exports.VsCodeOutputLogger = VsCodeOutputLogger;
//# sourceMappingURL=VsCodeOutputLogger.js.map