import { GetProject } from "../resources/openshift/Project";
import { ResourceFetcher } from "../fetch/ResourceFetcher";
import { KnativeSupportService } from "./support";
import { KubernetesService } from "./KubernetesService";
import { KubernetesConnectionStatus } from "./KubernetesConnection";
import { DeploymentState } from "../resources/common";
export class OpenShiftService {
    constructor(args) {
        this.args = args;
        this.kubernetesService = new KubernetesService(args);
        this.knativeSupportService = new KnativeSupportService({
            fetcher: this.kubernetesService.fetcher,
            namespace: args.connection.namespace,
        });
    }
    get knative() {
        return this.knativeSupportService;
    }
    get kubernetes() {
        return this.kubernetesService;
    }
    composeDeploymentUrlFromRoute(route) {
        return `https://${route.spec.host}`;
    }
    extractDeploymentState(args) {
        var _a;
        if (args.build) {
            if (!args.build.status || ["Failed", "Error", "Cancelled"].includes(args.build.status.phase)) {
                return DeploymentState.DOWN;
            }
            if (["New", "Pending"].includes(args.build.status.phase)) {
                return DeploymentState.PREPARING;
            }
            if (args.build.status.phase === "Running") {
                return DeploymentState.IN_PROGRESS;
            }
        }
        if (!args.deployment || !args.deployment.status) {
            return DeploymentState.IN_PROGRESS;
        }
        if (!args.deployment.status.replicas) {
            return DeploymentState.DOWN;
        }
        const progressingCondition = (_a = args.deployment.status.conditions) === null || _a === void 0 ? void 0 : _a.find((condition) => condition.type === "Progressing");
        if (!progressingCondition || progressingCondition.status !== "True") {
            return DeploymentState.DOWN;
        }
        if (!args.deployment.status.readyReplicas) {
            return DeploymentState.IN_PROGRESS;
        }
        return DeploymentState.UP;
    }
    async withFetch(callback) {
        return this.kubernetes.withFetch(callback);
    }
    async isConnectionEstablished(connection) {
        try {
            const testConnectionFetcher = new ResourceFetcher({ connection, proxyUrl: this.args.proxyUrl });
            await testConnectionFetcher.execute({ target: new GetProject({ namespace: connection.namespace }) });
            return KubernetesConnectionStatus.CONNECTED;
        }
        catch (error) {
            return KubernetesConnectionStatus.ERROR;
        }
    }
    newResourceName(prefix) {
        return this.kubernetes.newResourceName(prefix);
    }
}
//# sourceMappingURL=OpenShiftService.js.map