import { ResourceFetcher } from "../fetch/ResourceFetcher";
import { KnativeSupportService } from "./support";
import { KubernetesService, KubernetesServiceArgs } from "./KubernetesService";
import { DeploymentDescriptor } from "../resources/kubernetes/Deployment";
import { BuildDescriptor } from "../resources/openshift/Build";
import { RouteDescriptor } from "../resources/openshift/Route";
import { KubernetesConnection, KubernetesConnectionStatus } from "./KubernetesConnection";
import { DeploymentState, Resource } from "../resources/common";
export declare class OpenShiftService {
    readonly args: KubernetesServiceArgs;
    private knativeSupportService;
    private kubernetesService;
    constructor(args: KubernetesServiceArgs);
    get knative(): KnativeSupportService;
    get kubernetes(): KubernetesService;
    composeDeploymentUrlFromRoute(route: RouteDescriptor): string;
    extractDeploymentState(args: {
        deployment?: DeploymentDescriptor;
        build?: BuildDescriptor;
    }): DeploymentState;
    withFetch<T = Resource>(callback: (fetcher: ResourceFetcher) => Promise<T>): Promise<T>;
    isConnectionEstablished(connection: KubernetesConnection): Promise<KubernetesConnectionStatus>;
    newResourceName(prefix: string): string;
}
//# sourceMappingURL=OpenShiftService.d.ts.map