import { HttpMethod } from "../../fetch/FetchConstants";
import { CreateResourceFetchArgs, ResourceFetch } from "../../fetch/ResourceFetch";
import { ISelfSubjectAccessReview } from "kubernetes-models/authorization.k8s.io/v1";
import { ResourceDataSource } from "../common";
export type CreateSelfSubjectAccessReviewTemplateArgs = {
    resourceDataSource: ResourceDataSource.TEMPLATE;
    resource: string;
};
export type SelfSubjectAccessReviewDescriptor = ISelfSubjectAccessReview;
export type CreateSelfSubjectAccessReviewArgs = CreateResourceFetchArgs & (CreateSelfSubjectAccessReviewTemplateArgs | {
    descriptor: SelfSubjectAccessReviewDescriptor;
    resourceDataSource: ResourceDataSource.PROVIDED;
});
export declare const SELF_SUBJECT_ACCESS_REVIEW_TEMPLATE: (args: CreateResourceFetchArgs & CreateSelfSubjectAccessReviewTemplateArgs) => SelfSubjectAccessReviewDescriptor;
export declare class CreateSelfSubjectAccessReview extends ResourceFetch {
    protected args: CreateSelfSubjectAccessReviewArgs;
    constructor(args: CreateSelfSubjectAccessReviewArgs);
    method(): HttpMethod;
    body(): string;
    endpoint(): string;
}
//# sourceMappingURL=SelfSubjectAccessReview.d.ts.map