import { ResourceFetch } from "../../fetch/ResourceFetch";
import { HttpMethod } from "../../fetch/FetchConstants";
import { Secret } from "kubernetes-models/v1";
import { ResourceDataSource, commonLabels } from "../common";
export const SECRET_TEMPLATE = (args) => {
    const encodedData = Object.entries(args.data).reduce((acc, [key, value]) => ({
        ...acc,
        [key]: btoa(value),
    }), {});
    return new Secret({
        metadata: {
            name: args.resourceName,
            namespace: args.namespace,
            labels: commonLabels({ ...args }),
        },
        data: encodedData,
    }).toJSON();
};
export class CreateSecret extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : SECRET_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/api/${Secret.apiVersion}/namespaces/${this.args.namespace}/secrets`;
    }
}
export class DeleteSecret extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.DELETE;
    }
    endpoint() {
        return `/api/${Secret.apiVersion}/namespaces/${this.args.namespace}/secrets/${this.args.resourceName}`;
    }
}
//# sourceMappingURL=Secret.js.map