import { ResourceFetch } from "../../fetch/ResourceFetch";
import { ResourceDataSource, commonLabels } from "../common";
import { HttpMethod } from "../../fetch/FetchConstants";
import { KAFKA_SOURCE_FINALIZER, KnativeApiVersions } from "./api";
export const KAFKA_SOURCE_TEMPLATE = (args) => ({
    apiVersion: KnativeApiVersions.KAFKA_SOURCE,
    kind: "KafkaSource",
    metadata: {
        name: args.resourceName,
        namespace: args.namespace,
        finalizers: [KAFKA_SOURCE_FINALIZER],
        labels: commonLabels({ ...args }),
    },
    spec: {
        bootstrapServers: args.bootstrapServers,
        consumerGroup: args.createdBy,
        net: {
            tls: {
                enable: true,
            },
            sasl: {
                enable: true,
                type: {
                    secretKeyRef: {
                        name: args.secret.name,
                        key: args.secret.keyMechanism,
                    },
                },
                user: {
                    secretKeyRef: {
                        name: args.secret.name,
                        key: args.secret.keyId,
                    },
                },
                password: {
                    secretKeyRef: {
                        name: args.secret.name,
                        key: args.secret.keySecret,
                    },
                },
            },
        },
        sink: {
            ref: {
                apiVersion: KnativeApiVersions.SERVICE,
                kind: "Service",
                name: args.sinkService,
            },
        },
        topics: args.topics,
    },
});
export class CreateKafkaSource extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.POST;
    }
    body() {
        return JSON.stringify(this.args.resourceDataSource === ResourceDataSource.PROVIDED
            ? this.args.descriptor
            : KAFKA_SOURCE_TEMPLATE({ ...this.args }));
    }
    endpoint() {
        return `/apis/${KnativeApiVersions.KAFKA_SOURCE}/namespaces/${this.args.namespace}/kafkasources`;
    }
}
export class DeleteKafkaSource extends ResourceFetch {
    constructor(args) {
        super(args);
        this.args = args;
    }
    method() {
        return HttpMethod.DELETE;
    }
    endpoint() {
        return `/apis/${KnativeApiVersions.KAFKA_SOURCE}/namespaces/${this.args.namespace}/kafkasources/${this.args.resourceName}`;
    }
}
//# sourceMappingURL=KafkaSource.js.map