import * as React from "react";
import { FormHook } from "./FormHook";
export interface FormProps<Input, Schema> {
    id?: string;
    name?: string;
    locale: string;
    setFormRef?: (formElement: HTMLFormElement | null) => void;
    showInlineError?: boolean;
    autoSave?: boolean;
    autoSaveDelay?: number;
    placeholder?: boolean;
    onSubmit?: (model: object) => void;
    onValidate?: (model: object, error: object) => void;
    errorsField?: () => React.ReactNode;
    submitField?: () => React.ReactNode;
    notificationsPanel: boolean;
    openValidationTab?: () => void;
    formError: boolean;
    setFormError: React.Dispatch<React.SetStateAction<boolean>>;
    formInputs: Input;
    setFormInputs: React.Dispatch<React.SetStateAction<Input>>;
    formSchema?: Schema;
}
export type FormComponentProps<Input extends Record<string, any>, Schema extends Record<string, any>> = FormProps<Input, Schema> & FormHook<Input, Schema>;
export declare function FormComponent(props: React.PropsWithChildren<FormComponentProps<object, object>>): JSX.Element;
//# sourceMappingURL=FormComponent.d.ts.map