import { existsSync, mkdirSync, writeFileSync } from "fs";
import ErrorProcessor from "./ErrorProcessor";
import { join } from "path";
export default class Screenshots {
    constructor(driver, screenshotsDir) {
        this.driver = driver;
        this.screenshotsDir = screenshotsDir;
        if (!existsSync(screenshotsDir)) {
            mkdirSync(screenshotsDir, { recursive: true });
        }
    }
    async takePng(fileName) {
        const image = await ErrorProcessor.run(async () => await this.driver.takeScreenshot(), "Error while taking png screenshot with name: " + fileName);
        const pngPath = join(this.screenshotsDir, fileName + ".png");
        return writeFileSync(pngPath, image, "base64");
    }
    async takeHtml(fileName) {
        const pageSource = await ErrorProcessor.run(async () => await this.driver.getPageSource(), "Error while getting page source with name: " + fileName);
        const htmlPath = join(this.screenshotsDir, fileName + ".html");
        return writeFileSync(htmlPath, pageSource, "utf8");
    }
}
//# sourceMappingURL=ScreenShot.js.map