import { Key } from "selenium-webdriver";
import ErrorProcessor from "./ErrorProcessor";
import { platform } from "os";
export default class Clipboard {
    constructor(driver) {
        this.driver = driver;
    }
    async getContent() {
        const input = await this.addHelperInputToPage();
        await this.pasteContentToHelperInput(input);
        return await this.getTextFromHelperInput();
    }
    async setContent(textToClipboard) {
        await this.driver.executeScript("navigator.clipboard.writeText('" + textToClipboard + "');");
    }
    async getTextFromHelperInput() {
        const GET_TEXT_FROM_INPUT_CMD = "input=document.getElementById('copyPaste');" +
            "text=document.getElementById('copyPaste').value;" +
            "input.remove();" +
            "return text;";
        return await ErrorProcessor.run(async () => await this.driver.executeScript(GET_TEXT_FROM_INPUT_CMD), "Error while getting text from helper input.");
    }
    async pasteContentToHelperInput(input) {
        await ErrorProcessor.run(async () => await input.sendKeys(this.getCtrvKeys()), "Error while pasting contenct from clipboard to helper input by keys: " + this.getCtrvKeys());
    }
    getCtrvKeys() {
        if (platform() === "darwin") {
            return Key.SHIFT + Key.INSERT;
        }
        else {
            return Key.CONTROL + "v";
        }
    }
    async addHelperInputToPage() {
        const ADD_HELPER_INPUT_CMD = "input=document.createElement('input');" +
            "input.setAttribute('id','copyPaste');" +
            "return document.getElementsByTagName('body')[0].appendChild(input)";
        return await this.driver.executeScript(ADD_HELPER_INPUT_CMD);
    }
}
//# sourceMappingURL=Clipboard.js.map