import { By } from "selenium-webdriver";
import DecisionNavigator from "./DecisionNavigator";
import SideBar from "../SideBar";
class DmnSideBar extends SideBar {
    async openDecisionNavigator() {
        const navigatorButtonLocator = this.tools.by(DmnSideBar.NAVIGATOR_BUTTON_LOCATOR);
        await navigatorButtonLocator.wait(2000).untilPresent();
        const navigatorButton = await navigatorButtonLocator.getElement();
        const sideBar = await this.openSideBar(navigatorButton, "Decision Navigator");
        return await this.tools.createPageFragment(DecisionNavigator, sideBar);
    }
}
DmnSideBar.NAVIGATOR_BUTTON_LOCATOR = By.xpath("//div[./button[@data-title='Decision Navigator']]");
export default DmnSideBar;
//# sourceMappingURL=DmnSideBar.js.map