import { By } from "selenium-webdriver";
import PageFragment from "../../PageFragment";
class DecisionNavigator extends PageFragment {
    async waitUntilLoaded() {
        return await this.tools.by(DecisionNavigator.DECISION_GRAPH_LOCATOR).wait(5000).untilPresent();
    }
    async getItems() {
        return await this.tools.by(DecisionNavigator.ITEM_LOCATOR).getElements();
    }
    async getNodes() {
        const items = await this.getItems();
        items.shift();
        return items;
    }
    async getDmnName() {
        const items = await this.getItems();
        return await items[0].getAttribute("title");
    }
    async getNodeNames() {
        const nodes = await this.getNodes();
        return Promise.all(nodes.map((node) => node.getAttribute("title")));
    }
    async selectNode(name) {
        const node = await this.tools.by(By.xpath(`//li[@data-field='item'][@title='${name}']/div`)).getElement();
        return await node.click();
    }
    async selectNodeExpression(name) {
        const node = await this.tools
            .by(By.xpath(`//li[@data-field='item'][@title='${name}']/div/following-sibling::ul/li/div`))
            .getElement();
        return await node.click();
    }
}
DecisionNavigator.DECISION_GRAPH_LOCATOR = By.xpath("//div[@data-i18n-prefix='DecisionNavigatorTreeView.']");
DecisionNavigator.ITEM_LOCATOR = By.xpath("//li[@data-field='item']");
export default DecisionNavigator;
//# sourceMappingURL=DecisionNavigator.js.map