import { v4 as uuid } from "uuid";
export function pushFactMappings({ factMappingValuesModel, factMappingsModel, factMappingsToPush, }) {
    factMappingsToPush.forEach((factMappingToPush) => {
        var _a, _b;
        const expressionElements = factMappingToPush.expressionElements.map((expressionElement) => ({
            step: {
                __$$text: expressionElement,
            },
        }));
        const genericTypes = (_a = factMappingToPush.genericTypes) === null || _a === void 0 ? void 0 : _a.map((genericType) => ({
            __$$text: genericType,
        }));
        const newFactMapping = {
            className: { __$$text: factMappingToPush.className },
            columnWidth: { __$$text: (_b = factMappingToPush.columnWidth) !== null && _b !== void 0 ? _b : 150 },
            expressionAlias: { __$$text: factMappingToPush.expressionAlias },
            expressionElements: factMappingToPush.expressionElements
                ? {
                    ExpressionElement: expressionElements,
                }
                : undefined,
            expressionIdentifier: {
                name: { __$$text: `_${uuid()}`.toLocaleUpperCase() },
                type: { __$$text: factMappingToPush.expressionIdentifierType },
            },
            factAlias: {
                __$$text: factMappingToPush.factAlias,
            },
            factIdentifier: {
                name: {
                    __$$text: factMappingToPush.factIdentifierName,
                },
                className: {
                    __$$text: factMappingToPush.factIdentifierClassName,
                },
            },
            factMappingValueType: { __$$text: "NOT_EXPRESSION" },
            genericTypes: factMappingToPush.genericTypes
                ? {
                    string: genericTypes,
                }
                : undefined,
        };
        factMappingsModel.push(newFactMapping);
        factMappingValuesModel.forEach((scenario) => {
            scenario.factMappingValues.FactMappingValue.push({
                expressionIdentifier: {
                    name: { __$$text: newFactMapping.expressionIdentifier.name.__$$text },
                    type: { __$$text: newFactMapping.expressionIdentifier.type.__$$text },
                },
                factIdentifier: {
                    name: { __$$text: newFactMapping.factIdentifier.name.__$$text },
                    className: { __$$text: newFactMapping.factIdentifier.className.__$$text },
                },
            });
        });
    });
}
//# sourceMappingURL=pushFactMappings.js.map