import { isNumber } from "lodash";
export function deleteColumn({ factMappingIndexToRemove, factMappings, factMappingValues, isBackground, isInstance, selectedColumnIndex, }) {
    const factMappingToRemove = factMappings[factMappingIndexToRemove];
    const groupType = factMappingToRemove.expressionIdentifier.type.__$$text;
    const instanceName = factMappingToRemove.factIdentifier.name.__$$text;
    const instanceType = factMappingToRemove.factIdentifier.className.__$$text;
    const allFactMappingWithIndexesToRemove = isInstance
        ? factMappings
            .map((factMapping, index) => {
            var _a, _b;
            if (factMapping.expressionIdentifier.type.__$$text === groupType &&
                ((_a = factMapping.factIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) === instanceName &&
                ((_b = factMapping.factIdentifier.className) === null || _b === void 0 ? void 0 : _b.__$$text) === instanceType) {
                return { factMappingIndex: index, factMapping: factMapping };
            }
            else {
                return {};
            }
        })
            .filter((item) => isNumber(item.factMappingIndex))
        : [{ factMappingIndex: selectedColumnIndex + (isBackground ? 0 : 1), factMapping: factMappingToRemove }];
    factMappings.splice(allFactMappingWithIndexesToRemove[0].factMappingIndex, allFactMappingWithIndexesToRemove.length);
    factMappingValues.forEach((rowData) => {
        allFactMappingWithIndexesToRemove.forEach((itemToRemove) => {
            const factMappingValueColumnIndexToRemove = rowData.factMappingValues.FactMappingValue.findIndex((factMappingValue) => {
                var _a, _b, _c, _d, _e, _f, _g, _h;
                return ((_a = factMappingValue.factIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text) === ((_b = itemToRemove.factMapping.factIdentifier.name) === null || _b === void 0 ? void 0 : _b.__$$text) &&
                    ((_c = factMappingValue.factIdentifier.className) === null || _c === void 0 ? void 0 : _c.__$$text) ===
                        ((_d = itemToRemove.factMapping.factIdentifier.className) === null || _d === void 0 ? void 0 : _d.__$$text) &&
                    ((_e = factMappingValue.expressionIdentifier.name) === null || _e === void 0 ? void 0 : _e.__$$text) ===
                        ((_f = itemToRemove.factMapping.expressionIdentifier.name) === null || _f === void 0 ? void 0 : _f.__$$text) &&
                    ((_g = factMappingValue.expressionIdentifier.type) === null || _g === void 0 ? void 0 : _g.__$$text) ===
                        ((_h = itemToRemove.factMapping.expressionIdentifier.type) === null || _h === void 0 ? void 0 : _h.__$$text);
            });
            rowData.factMappingValues.FactMappingValue.splice(factMappingValueColumnIndexToRemove, 1);
        });
    });
    return { deletedFactMappingIndexs: allFactMappingWithIndexesToRemove.flatMap((item) => item.factMappingIndex) };
}
//# sourceMappingURL=deleteColumn.js.map