import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect, useMemo, useState } from "react";
import { cloneDeep } from "lodash";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Button } from "@patternfly/react-core/dist/js/components/Button/";
import { Divider } from "@patternfly/react-core/dist/js/components/Divider/";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { HelpIcon } from "@patternfly/react-icons/dist/esm/icons/help-icon";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Text } from "@patternfly/react-core/dist/js/components/Text";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Toolbar, ToolbarContent, ToolbarItem } from "@patternfly/react-core/dist/js/components/Toolbar/";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip/";
import { TreeView, TreeViewSearch } from "@patternfly/react-core/dist/js/components/TreeView/";
import { WarningTriangleIcon } from "@patternfly/react-icons/dist/esm/icons/warning-triangle-icon";
import { useTestScenarioEditorI18n } from "../i18n";
import "./TestScenarioDrawerDataSelectorPanel.css";
import { useExternalModels } from "../externalModels/TestScenarioEditorDependenciesContext";
import { useTestScenarioEditorStore, useTestScenarioEditorStoreApi } from "../store/TestScenarioStoreContext";
import { TestScenarioEditorTab } from "../store/TestScenarioEditorStore";
import { updateColumn } from "../mutations/updateColumn";
import { Spinner } from "@patternfly/react-core/dist/js/components/Spinner/Spinner";
const isRootDataObjectAssignable = (dataObject, assignedExpressionElements) => {
    let filtered = true;
    for (const expressionElements of assignedExpressionElements) {
        if (!expressionElements ||
            !expressionElements.ExpressionElement ||
            expressionElements.ExpressionElement.length === 0) {
            continue;
        }
        if (expressionElements.ExpressionElement[0].step.__$$text === dataObject.expressionElements[0]) {
            filtered = false;
            break;
        }
    }
    return filtered;
};
function filterOutDataObjectChildrenByExpressionElements(dataObject, allExpressionElements) {
    if (dataObject.children) {
        dataObject.children = dataObject.children.filter((child) => {
            return filterOutDataObjectChildrenByExpressionElements(child, allExpressionElements);
        });
    }
    if (dataObject.children === undefined && dataObject.name === "value") {
        return !allExpressionElements.includes(dataObject.id);
    }
    return !allExpressionElements.includes(dataObject.expressionElements.join("."));
}
const filterDataObjectsById = (item, itemId) => {
    if (item.id === itemId) {
        return true;
    }
    if (item.children) {
        const dataObjects = item.children
            .map((object) => Object.assign({}, object))
            .filter((child) => filterDataObjectsById(child, itemId));
        return dataObjects.length > 0;
    }
    return false;
};
const filterDataObjectsByName = (item, name) => {
    if (item.name.toLowerCase().includes(name.toLowerCase())) {
        return true;
    }
    if (item.children) {
        const dataObjects = item.children
            .map((object) => Object.assign({}, object))
            .filter((child) => filterDataObjectsByName(child, name));
        return dataObjects.length > 0;
    }
    return false;
};
const findDataObjectRootParent = (dataObjects, itemId) => {
    const filtered = dataObjects
        .map((object) => Object.assign({}, object))
        .filter((item) => filterDataObjectsById(item, itemId));
    return filtered[0];
};
const filterTypesItems = (dataObject, factIdentifierName) => {
    return dataObject.name === factIdentifierName;
};
function findTestScenarioDataObjectById(testScenarioDataObjects, id) {
    for (const testScenarioDataObject of testScenarioDataObjects) {
        if (testScenarioDataObject.id === id) {
            return testScenarioDataObject;
        }
        else if (testScenarioDataObject.children) {
            const testScenarioDataObjectChild = findTestScenarioDataObjectById(testScenarioDataObject.children, id);
            if (testScenarioDataObjectChild) {
                return testScenarioDataObjectChild;
            }
        }
    }
    return undefined;
}
function TestScenarioDataSelectorPanel() {
    var _a, _b;
    const { i18n } = useTestScenarioEditorI18n();
    const { externalModelsByNamespace } = useExternalModels();
    const dataObjects = useTestScenarioEditorStore((state) => state.computed(state).getDataObjects(externalModelsByNamespace));
    const scesimModel = useTestScenarioEditorStore((state) => state.scesim.model);
    const tableStatus = useTestScenarioEditorStore((state) => state.table);
    const tabStatus = useTestScenarioEditorStore((state) => state.navigation.tab);
    const testScenarioEditorStoreApi = useTestScenarioEditorStoreApi();
    const testScenarioType = (_a = scesimModel.ScenarioSimulationModel.settings.type) === null || _a === void 0 ? void 0 : _a.__$$text.toUpperCase();
    const referencedDmnNamespace = (_b = scesimModel.ScenarioSimulationModel.settings.dmnNamespace) === null || _b === void 0 ? void 0 : _b.__$$text;
    const selectedColumnMetadata = tabStatus === TestScenarioEditorTab.SIMULATION
        ? tableStatus.simulation.selectedColumn
        : tableStatus.background.selectedColumn;
    const [allExpanded, setAllExpanded] = useState(false);
    const [dataSelectorStatus, setDataSelectorStatus] = useState(0);
    const [filteredItems, setFilteredItems] = useState(dataObjects);
    const [treeViewStatus, setTreeViewStatus] = useState({
        activeItems: [],
        searchKey: "",
        isExpanded: false,
    });
    const filterOutAlreadyAssignedDataObjectsAndChildren = useCallback((selectedColumnExpressionElement, isBackground) => {
        var _a, _b, _c;
        const testScenarioDescriptor = isBackground
            ? scesimModel.ScenarioSimulationModel.background.scesimModelDescriptor
            : scesimModel.ScenarioSimulationModel.simulation.scesimModelDescriptor;
        const assignedExpressionElements = ((_a = testScenarioDescriptor.factMappings.FactMapping) !== null && _a !== void 0 ? _a : []).reduce((acc, factMapping) => factMapping.expressionElements ? [...acc, factMapping.expressionElements] : acc, []);
        const assignedIds = ((_b = testScenarioDescriptor.factMappings.FactMapping) !== null && _b !== void 0 ? _b : [])
            .filter((factMapping) => factMapping.expressionElements && factMapping.expressionElements.ExpressionElement)
            .reduce((assignedIds, factMapping) => {
            var _a, _b, _c;
            const assignedId = ((_b = (_a = factMapping.expressionElements) === null || _a === void 0 ? void 0 : _a.ExpressionElement) !== null && _b !== void 0 ? _b : [])
                .map((expressionElement) => {
                var _a;
                if (((_a = factMapping.expressionAlias) === null || _a === void 0 ? void 0 : _a.__$$text) === "value") {
                    return `${expressionElement.step.__$$text}.value`;
                }
                return expressionElement.step.__$$text;
            })
                .join(".");
            if ((_c = factMapping.factIdentifier.name) === null || _c === void 0 ? void 0 : _c.__$$text) {
                assignedIds.add(factMapping.factIdentifier.name.__$$text);
            }
            assignedIds.add(assignedId);
            return assignedIds;
        }, new Set());
        if (!(selectedColumnExpressionElement === null || selectedColumnExpressionElement === void 0 ? void 0 : selectedColumnExpressionElement.ExpressionElement) ||
            ((_c = selectedColumnExpressionElement === null || selectedColumnExpressionElement === void 0 ? void 0 : selectedColumnExpressionElement.ExpressionElement) === null || _c === void 0 ? void 0 : _c.length) === 0) {
            return dataObjects
                .map((object) => cloneDeep(object))
                .filter((dataObject) => isRootDataObjectAssignable(dataObject, assignedExpressionElements));
        }
        return dataObjects
            .map((object) => cloneDeep(object))
            .filter((dataObject) => !isRootDataObjectAssignable(dataObject, [selectedColumnExpressionElement]))
            .reduce((acc, dataObject) => {
            var _a;
            filterOutDataObjectChildrenByExpressionElements(dataObject, [...assignedIds]);
            if (((_a = dataObject.children) === null || _a === void 0 ? void 0 : _a.length) === 0 && assignedIds.has(dataObject.id)) {
                return acc;
            }
            return [...acc, dataObject];
        }, []);
    }, [dataObjects, scesimModel.ScenarioSimulationModel]);
    useEffect(() => {
        var _a;
        console.debug("========SELECTOR PANEL USE EFFECT===========");
        console.debug("Selected Column:", selectedColumnMetadata);
        console.debug("All Data Objects:", dataObjects);
        if (!selectedColumnMetadata || ((_a = selectedColumnMetadata.factMapping.expressionIdentifier.type) === null || _a === void 0 ? void 0 : _a.__$$text) == "OTHER") {
            setDataSelectorStatus(0);
            setFilteredItems(dataObjects);
            setTreeViewStatus({ activeItems: [], searchKey: "", isExpanded: false });
            console.debug("Case 1");
            console.debug("=============USE EFFECT END===============");
            return;
        }
        if (selectedColumnMetadata.factMapping.className.__$$text === "java.lang.Void") {
            const isFactIdentifierAssigned = selectedColumnMetadata.factMapping.factIdentifier.className.__$$text !== "java.lang.Void";
            let filteredDataObjects = filterOutAlreadyAssignedDataObjectsAndChildren(selectedColumnMetadata.factMapping.expressionElements, selectedColumnMetadata.isBackground);
            const isUserFilterPresent = treeViewStatus.searchKey.trim() !== "";
            if (isUserFilterPresent) {
                filteredDataObjects = filteredDataObjects.filter((item) => filterDataObjectsByName(item, treeViewStatus.searchKey));
            }
            setDataSelectorStatus(1);
            setFilteredItems(filteredDataObjects);
            setTreeViewStatus((prev) => {
                return {
                    ...prev,
                    activeItems: [],
                    isExpanded: isFactIdentifierAssigned || isUserFilterPresent,
                };
            });
            console.debug("Case 2");
            console.debug("Filtered Data Objects:", filteredDataObjects);
            console.debug("=============USE EFFECT END===============");
            return;
        }
        const factIdentifier = selectedColumnMetadata.factMapping.expressionElements.ExpressionElement[0].step.__$$text;
        const filteredDataObjects = dataObjects.filter((dataObject) => filterTypesItems(dataObject, factIdentifier));
        const isExpressionType = selectedColumnMetadata.factMapping.factMappingValueType.__$$text === "EXPRESSION";
        const isSimpleTypeFact = selectedColumnMetadata.factMapping.expressionElements.ExpressionElement.length === 1 &&
            selectedColumnMetadata.factMapping.className.__$$text !== "java.lang.Void";
        let fieldId;
        if (isExpressionType) {
            fieldId = selectedColumnMetadata.factMapping.expressionElements.ExpressionElement[0].step.__$$text;
        }
        else if (isSimpleTypeFact) {
            fieldId = selectedColumnMetadata.factMapping
                .expressionElements.ExpressionElement[0].step.__$$text.concat(".")
                .concat("value");
        }
        else {
            fieldId = selectedColumnMetadata.factMapping
                .expressionElements.ExpressionElement.map((expressionElement) => expressionElement.step.__$$text)
                .join(".");
        }
        const treeViewItemToActivate = findTestScenarioDataObjectById(dataObjects, fieldId);
        setDataSelectorStatus(2);
        setFilteredItems(filteredDataObjects);
        setTreeViewStatus({ activeItems: [treeViewItemToActivate], searchKey: "", isExpanded: true });
        console.debug("Case 3");
        console.debug("=============USE EFFECT END===============");
    }, [
        dataObjects,
        filterOutAlreadyAssignedDataObjectsAndChildren,
        scesimModel,
        selectedColumnMetadata,
        treeViewStatus.searchKey,
    ]);
    const treeViewEmptyStatus = useMemo(() => {
        const isReferencedFileLoaded = testScenarioType === "RULE" || (externalModelsByNamespace === null || externalModelsByNamespace === void 0 ? void 0 : externalModelsByNamespace.has(referencedDmnNamespace));
        const isTreeViewNotEmpty = filteredItems.length > 0;
        const activeItem = treeViewStatus.activeItems[0];
        const treeViewVisibleStatus = isReferencedFileLoaded ? (isTreeViewNotEmpty ? "visible" : "hidden") : "loading";
        const title = dataObjects.length === 0
            ? testScenarioType === "DMN"
                ? i18n.drawer.dataSelector.emptyDataObjectsTitleDMN
                : i18n.drawer.dataSelector.emptyDataObjectsTitleRule
            : activeItem !== undefined
                ? i18n.drawer.dataSelector.emptyDataObjectsTitle
                : i18n.drawer.dataSelector.emptyDataObjectsMissingTitle;
        const description = dataObjects.length === 0
            ? testScenarioType === "DMN"
                ? i18n.drawer.dataSelector.emptyDataObjectsDescriptionDMN
                : i18n.drawer.dataSelector.emptyDataObjectsDescriptionRule
            : activeItem !== undefined
                ? i18n.drawer.dataSelector.emptyDataObjectsDescription
                : i18n.drawer.dataSelector.emptyDataObjectsMissingDescription;
        {
            testScenarioType === "DMN"
                ? i18n.drawer.dataSelector.emptyDataObjectsTitleDMN
                : i18n.drawer.dataSelector.emptyDataObjectsTitleRule;
        }
        return { description: description, icon: WarningTriangleIcon, title: title, visibility: treeViewVisibleStatus };
    }, [
        dataObjects.length,
        externalModelsByNamespace,
        filteredItems.length,
        i18n.drawer.dataSelector,
        referencedDmnNamespace,
        testScenarioType,
        treeViewStatus,
    ]);
    const insertDataObjectButtonStatus = useMemo(() => {
        if (!selectedColumnMetadata) {
            return {
                message: i18n.drawer.dataSelector.insertDataObjectTooltipColumnSelectionMessage,
                enabled: false,
            };
        }
        if (!treeViewStatus.activeItems === undefined || treeViewStatus.activeItems.length !== 1) {
            return {
                message: i18n.drawer.dataSelector.insertDataObjectTooltipDataObjectSelectionMessage,
                enabled: false,
            };
        }
        const activeItem = treeViewStatus.activeItems[0];
        const unassignedDataObjects = filterOutAlreadyAssignedDataObjectsAndChildren(selectedColumnMetadata.factMapping.expressionElements, selectedColumnMetadata.isBackground);
        const isAssignable = activeItem !== undefined &&
            (activeItem.children !== undefined &&
                activeItem.children.length > 0 &&
                activeItem.expressionElements.length > 1) === false &&
            findTestScenarioDataObjectById(unassignedDataObjects, activeItem.id) !== undefined;
        if (treeViewStatus.activeItems.length === 1 && isAssignable === false) {
            return {
                message: i18n.drawer.dataSelector.insertDataObjectTooltipDataObjectAlreadyAssignedMessage,
                enabled: false,
            };
        }
        return { message: i18n.drawer.dataSelector.insertDataObjectTooltipDataObjectAssignMessage, enabled: true };
    }, [filterOutAlreadyAssignedDataObjectsAndChildren, i18n, selectedColumnMetadata, treeViewStatus]);
    const onAllExpandedToggle = useCallback((_event) => {
        setAllExpanded((prev) => !prev);
    }, []);
    const onInsertDataObjectClick = useCallback(() => {
        const userSelectedTestScenarioObject = treeViewStatus.activeItems[0];
        if (userSelectedTestScenarioObject === undefined) {
            console.error("No Data Object selected in the item view.");
            return;
        }
        const rootSelectedTestScenarioDataObject = findDataObjectRootParent(dataObjects, treeViewStatus.activeItems[0].id.toString());
        const isBackground = selectedColumnMetadata.isBackground;
        const isRootType = rootSelectedTestScenarioDataObject.id === userSelectedTestScenarioObject.id;
        const expressionAlias = isRootType
            ? "expression </>"
            : userSelectedTestScenarioObject.id.replace(userSelectedTestScenarioObject.expressionElements[0] + ".", "");
        const factMappingValueType = isRootType ? "EXPRESSION" : "NOT_EXPRESSION";
        testScenarioEditorStoreApi.setState((state) => {
            var _a, _b, _c, _d, _e;
            const factMappings = isBackground
                ? state.scesim.model.ScenarioSimulationModel.background.scesimModelDescriptor.factMappings.FactMapping
                : state.scesim.model.ScenarioSimulationModel.simulation.scesimModelDescriptor.factMappings.FactMapping;
            const factMappingValuesTypes = isBackground
                ? state.scesim.model.ScenarioSimulationModel.background.scesimData.BackgroundData
                : state.scesim.model.ScenarioSimulationModel.simulation.scesimData.Scenario;
            const { updatedFactMapping } = updateColumn({
                className: userSelectedTestScenarioObject.className,
                expressionAlias: expressionAlias,
                expressionElementsSteps: userSelectedTestScenarioObject.expressionElements,
                expressionIdentifierName: (_a = selectedColumnMetadata.factMapping.expressionIdentifier.name) === null || _a === void 0 ? void 0 : _a.__$$text,
                expressionIdentifierType: (_b = selectedColumnMetadata.factMapping.expressionIdentifier.type) === null || _b === void 0 ? void 0 : _b.__$$text,
                factMappings: factMappings,
                factClassName: rootSelectedTestScenarioDataObject.className,
                factIdentifierClassName: (_c = selectedColumnMetadata.factMapping.factIdentifier.className) === null || _c === void 0 ? void 0 : _c.__$$text,
                factIdentifierName: (_d = selectedColumnMetadata.factMapping.factIdentifier.name) === null || _d === void 0 ? void 0 : _d.__$$text,
                factMappingValuesTypes: factMappingValuesTypes,
                factMappingValueType: factMappingValueType,
                factName: rootSelectedTestScenarioDataObject.name,
                genericTypes: (_e = userSelectedTestScenarioObject.collectionGenericType) !== null && _e !== void 0 ? _e : [],
                selectedColumnIndex: selectedColumnMetadata.index,
            });
            state.dispatch(state).table.updateSelectedColumn({
                factMapping: updatedFactMapping,
                index: selectedColumnMetadata.index,
                isBackground: isBackground,
            });
        });
    }, [dataObjects, selectedColumnMetadata, testScenarioEditorStoreApi, treeViewStatus.activeItems]);
    const onClearSelectionClicked = useCallback((_event) => {
        setTreeViewStatus((prev) => {
            return {
                ...prev,
                activeItems: [],
            };
        });
    }, []);
    const onSearchTreeView = useCallback((event) => setTreeViewStatus((prev) => {
        return {
            ...prev,
            searchKey: event.target.value,
        };
    }), []);
    const onSelectTreeViewItem = useCallback((_event, treeViewItem) => {
        setTreeViewStatus((prev) => {
            return {
                ...prev,
                activeItems: [treeViewItem],
            };
        });
    }, []);
    const treeViewSearchToolbar = (_jsx(Toolbar, { style: { padding: 0 }, children: _jsx(ToolbarContent, { style: { padding: 0 }, children: _jsx(ToolbarItem, { widths: { default: "100%" }, children: _jsx(TreeViewSearch, { disabled: dataSelectorStatus !== 1, id: "input-search", name: "search-input", onSearch: onSearchTreeView, value: treeViewStatus.searchKey }) }) }) }));
    return (_jsxs(Stack, { children: [_jsx(StackItem, { children: _jsxs(Text, { className: "kie-scesim-editor-drawer-data-objects--text", children: [testScenarioType === "DMN"
                            ? i18n.drawer.dataSelector.descriptionDMN
                            : i18n.drawer.dataSelector.descriptionRule, _jsx(Tooltip, { content: testScenarioType === "DMN"
                                ? i18n.drawer.dataSelector.dataObjectsDescriptionDMN
                                : i18n.drawer.dataSelector.dataObjectsDescriptionRule, children: _jsx(Icon, { className: "kie-scesim-editor-drawer-data-objects--info-icon", size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] }) }), _jsx(Divider, {}), _jsx(StackItem, { isFilled: true, children: _jsx("div", { className: "kie-scesim-editor-drawer-data-objects--selector", children: (treeViewEmptyStatus.visibility === "visible" && (_jsx("div", { "aria-disabled": true, children: _jsx(TreeView, { activeItems: treeViewStatus.activeItems, allExpanded: allExpanded || treeViewStatus.isExpanded, className: dataSelectorStatus !== 0
                                ? undefined
                                : "kie-scesim-editor-drawer-data-objects--selector-disabled", data: filteredItems, hasBadges: true, hasSelectableNodes: true, onSelect: onSelectTreeViewItem, toolbar: treeViewSearchToolbar }) }))) ||
                        (treeViewEmptyStatus.visibility === "hidden" && (_jsx(Bullseye, { children: _jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: treeViewEmptyStatus.icon }), _jsx(Title, { headingLevel: "h4", size: "lg", children: treeViewEmptyStatus.title }), _jsx(EmptyStateBody, { children: treeViewEmptyStatus.description })] }) }))) ||
                        (treeViewEmptyStatus.visibility === "loading" && (_jsx(Bullseye, { style: { paddingTop: "10px" }, children: _jsx(Spinner, { "aria-label": "Data Objects loading" }) }))) }) }), _jsx(Divider, {}), _jsx(StackItem, { children: _jsxs("div", { className: "kie-scesim-editor-drawer-data-objects--button-container", children: [_jsx(Tooltip, { content: insertDataObjectButtonStatus.message, children: _jsx(Button, { isAriaDisabled: !insertDataObjectButtonStatus.enabled, onClick: onInsertDataObjectClick, variant: "primary", children: i18n.drawer.dataSelector.insertDataObject }) }), _jsx(Button, { isDisabled: treeViewStatus.activeItems.length !== 1 || dataSelectorStatus !== 1, onClick: onClearSelectionClicked, variant: "secondary", children: i18n.drawer.dataSelector.clearSelection }), _jsx(Button, { isDisabled: filteredItems.length < 1 ||
                                treeViewStatus.isExpanded ||
                                dataSelectorStatus !== 1, onClick: onAllExpandedToggle, variant: "link", children: allExpanded ? i18n.drawer.dataSelector.collapseAll : i18n.drawer.dataSelector.expandAll })] }) })] }));
}
export default TestScenarioDataSelectorPanel;
//# sourceMappingURL=TestScenarioDrawerDataSelectorPanel.js.map