import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useEffect } from "react";
import { Button, ButtonVariant } from "@patternfly/react-core/dist/js/components/Button";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStatePrimary, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { ExternalLinkAltIcon } from "@patternfly/react-icons/dist/js/icons/external-link-alt-icon";
import { ClipboardCopy, ClipboardCopyVariant } from "@patternfly/react-core/dist/js/components/ClipboardCopy";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { useTestScenarioEditorI18n } from "./i18n";
import { useTestScenarioEditor } from "./TestScenarioEditorContext";
export function TestScenarioEditorErrorFallback({ error, resetErrorBoundary }) {
    const { i18n } = useTestScenarioEditorI18n();
    const { testScenarioEditorModelBeforeEditingRef, issueTrackerHref } = useTestScenarioEditor();
    const resetToLastWorkingState = useCallback(() => {
        resetErrorBoundary(testScenarioEditorModelBeforeEditingRef.current);
    }, [testScenarioEditorModelBeforeEditingRef, resetErrorBoundary]);
    useEffect(() => {
        console.error(error);
    }, [error]);
    return (_jsx(Flex, { justifyContent: { default: "justifyContentCenter" }, style: { marginTop: "100px" }, children: _jsxs(EmptyState, { style: { maxWidth: "1280px" }, children: [_jsx(EmptyStateIcon, { icon: () => _jsx("div", { style: { fontSize: "3em" }, children: "\uD83D\uDE15" }) }), _jsx(Title, { size: "lg", headingLevel: "h4", children: i18n.errorFallBack.title }), _jsx(EmptyStateBody, { children: i18n.errorFallBack.body }), _jsx("br", {}), _jsx(ClipboardCopy, { isReadOnly: true, isExpanded: false, hoverTip: "Copy", clickTip: "Copied", variant: ClipboardCopyVariant.expansion, style: { textAlign: "left", whiteSpace: "pre-wrap", fontFamily: "monospace" }, children: JSON.stringify({
                        name: error.name,
                        message: error.message,
                        cause: error.cause,
                        stack: error.stack,
                    }, null, 2).replaceAll("\\n", "\n") }), _jsx("br", {}), _jsxs(EmptyStatePrimary, { children: [_jsx(Button, { variant: ButtonVariant.link, onClick: resetToLastWorkingState, children: i18n.errorFallBack.lastActionButton }), issueTrackerHref && (_jsx("a", { href: issueTrackerHref, target: "_blank", children: _jsxs(Button, { variant: ButtonVariant.link, icon: _jsx(ExternalLinkAltIcon, {}), children: [i18n.errorFallBack.fileIssueHref, "..."] }) }))] })] }) }));
}
//# sourceMappingURL=TestScenarioEditorErrorFallback.js.map