import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import "@patternfly/react-core/dist/styles/base.css";
import * as React from "react";
import { useCallback, useEffect, useImperativeHandle, useMemo, useRef } from "react";
import { I18nDictionariesProvider } from "@kie-tools-core/i18n/dist/react-components";
import { testScenarioEditorDictionaries, TestScenarioEditorI18nContext, testScenarioEditorI18nDefaults } from "./i18n";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Drawer, DrawerContent, DrawerContentBody } from "@patternfly/react-core/dist/js/components/Drawer";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Flex } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Icon } from "@patternfly/react-core/dist/js/components/Icon";
import { Spinner } from "@patternfly/react-core/dist/js/components/Spinner";
import { Tabs, Tab, TabTitleIcon, TabTitleText } from "@patternfly/react-core/dist/js/components/Tabs";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import TableIcon from "@patternfly/react-icons/dist/esm/icons/table-icon";
import HelpIcon from "@patternfly/react-icons/dist/esm/icons/help-icon";
import { ErrorBoundary } from "react-error-boundary";
import { CommandsContextProvider, useCommands } from "./commands/CommandsContextProvider";
import TestScenarioCreationPanel from "./creation/TestScenarioCreationPanel";
import TestScenarioDrawerPanel from "./drawer/TestScenarioDrawerPanel";
import TestScenarioSideBarMenu from "./sidebar/TestScenarioSideBarMenu";
import TestScenarioTable from "./table/TestScenarioTable";
import { useTestScenarioEditorI18n } from "./i18n";
import "./TestScenarioEditor.css";
import { ComputedStateCache } from "./store/ComputedStateCache";
import { createTestScenarioEditorStore, TestScenarioEditorTab } from "./store/TestScenarioEditorStore";
import { TestScenarioEditorStoreApiContext, useTestScenarioEditorStore, useTestScenarioEditorStoreApi, } from "./store/TestScenarioStoreContext";
import { TestScenarioEditorErrorFallback } from "./TestScenarioEditorErrorFallback";
import { TestScenarioEditorContextProvider, useTestScenarioEditor } from "./TestScenarioEditorContext";
import { TestScenarioEditorExternalModelsContextProvider, useExternalModels, } from "./externalModels/TestScenarioEditorDependenciesContext";
import { useEffectAfterFirstRender } from "./hook/useEffectAfterFirstRender";
import { INITIAL_COMPUTED_CACHE } from "./store/computed/initial";
const CURRENT_SUPPORTED_VERSION = "1.8";
var TestScenarioFileStatus;
(function (TestScenarioFileStatus) {
    TestScenarioFileStatus[TestScenarioFileStatus["EMPTY"] = 0] = "EMPTY";
    TestScenarioFileStatus[TestScenarioFileStatus["ERROR"] = 1] = "ERROR";
    TestScenarioFileStatus[TestScenarioFileStatus["NEW"] = 2] = "NEW";
    TestScenarioFileStatus[TestScenarioFileStatus["UNSUPPORTED"] = 3] = "UNSUPPORTED";
    TestScenarioFileStatus[TestScenarioFileStatus["VALID"] = 4] = "VALID";
})(TestScenarioFileStatus || (TestScenarioFileStatus = {}));
function TestScenarioMainPanel() {
    var _a, _b, _c;
    const { i18n } = useTestScenarioEditorI18n();
    const { commandsRef } = useCommands();
    const { externalModelsByNamespace } = useExternalModels();
    const testScenarioEditorStoreApi = useTestScenarioEditorStoreApi();
    const navigation = useTestScenarioEditorStore((state) => state.navigation);
    const scesimModel = useTestScenarioEditorStore((state) => state.scesim.model);
    const testScenarioDmnNamespace = (_a = scesimModel.ScenarioSimulationModel.settings.dmnNamespace) === null || _a === void 0 ? void 0 : _a.__$$text;
    const testScenarioDmnFilePath = (_b = scesimModel.ScenarioSimulationModel.settings.dmnFilePath) === null || _b === void 0 ? void 0 : _b.__$$text;
    const testScenarioType = (_c = scesimModel.ScenarioSimulationModel.settings.type) === null || _c === void 0 ? void 0 : _c.__$$text.toUpperCase();
    const scenarioTableScrollableElementRef = useRef(null);
    const backgroundTableScrollableElementRef = useRef(null);
    const isMissingDataObjectsNotificationEnabled = useMemo(() => {
        var _a;
        const isReferencedDmnFileMissing = externalModelsByNamespace &&
            externalModelsByNamespace.has(testScenarioDmnNamespace) &&
            (!externalModelsByNamespace.get(testScenarioDmnNamespace) ||
                ((_a = externalModelsByNamespace.get(testScenarioDmnNamespace)) === null || _a === void 0 ? void 0 : _a.normalizedPosixPathRelativeToTheOpenFile) !==
                    testScenarioDmnFilePath);
        return testScenarioType === "RULE" || isReferencedDmnFileMissing;
    }, [externalModelsByNamespace, testScenarioDmnFilePath, testScenarioDmnNamespace, testScenarioType]);
    const onTabChanged = useCallback((_event, tab) => {
        testScenarioEditorStoreApi.setState((state) => {
            state.navigation.tab = tab;
        });
    }, [testScenarioEditorStoreApi]);
    const showDockPanel = useCallback((show) => {
        testScenarioEditorStoreApi.setState((state) => {
            state.navigation.dock.isOpen = show;
        });
    }, [testScenarioEditorStoreApi]);
    useEffect(() => {
        if (!commandsRef.current) {
            return;
        }
        commandsRef.current.toggleTestScenarioDock = async () => {
            console.debug("Test Scenario Editor: COMMANDS: Toggle dock panel...");
            testScenarioEditorStoreApi.setState((state) => {
                state.navigation.dock.isOpen = !state.navigation.dock.isOpen;
            });
        };
    }, [testScenarioEditorStoreApi, commandsRef]);
    return (_jsxs(_Fragment, { children: [_jsx("div", { className: "kie-scesim-editor--content", children: _jsx(Drawer, { isExpanded: navigation.dock.isOpen, isInline: true, position: "right", children: _jsx(DrawerContent, { panelContent: _jsx(TestScenarioDrawerPanel, { onDrawerClose: () => showDockPanel(false) }), children: _jsxs(DrawerContentBody, { children: [isMissingDataObjectsNotificationEnabled && (_jsx("div", { className: "kie-scesim-editor--content-alert", children: _jsx(Alert, { variant: "danger", title: testScenarioType === "DMN"
                                            ? i18n.alerts.dmnDataRetrievedFromScesim
                                            : i18n.alerts.ruleDataRetrievedFromScesim }) })), _jsx("div", { className: "kie-scesim-editor--content-tabs", children: _jsxs(Tabs, { isFilled: true, activeKey: navigation.tab, onSelect: onTabChanged, role: "region", children: [_jsx(Tab, { eventKey: TestScenarioEditorTab.SIMULATION, title: _jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(TableIcon, {}) }), _jsx(TabTitleText, { children: i18n.tab.scenarioTabTitle }), _jsx(Tooltip, { content: i18n.tab.scenarioTabInfo, children: _jsx(Icon, { size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] }), children: _jsx("div", { className: "kie-scesim-editor--scenario-table-container", ref: scenarioTableScrollableElementRef, children: _jsx(TestScenarioTable, { tableData: scesimModel.ScenarioSimulationModel.simulation, scrollableParentRef: scenarioTableScrollableElementRef }) }) }), _jsx(Tab, { eventKey: TestScenarioEditorTab.BACKGROUND, title: _jsxs(_Fragment, { children: [_jsx(TabTitleIcon, { children: _jsx(TableIcon, {}) }), _jsx(TabTitleText, { children: i18n.tab.backgroundTabTitle }), _jsx(Tooltip, { content: i18n.tab.backgroundTabInfo, children: _jsx(Icon, { size: "sm", status: "info", children: _jsx(HelpIcon, {}) }) })] }), children: _jsx("div", { className: "kie-scesim-editor--background-table-container", ref: backgroundTableScrollableElementRef, children: _jsx(TestScenarioTable, { tableData: scesimModel.ScenarioSimulationModel.background, scrollableParentRef: backgroundTableScrollableElementRef }) }) })] }) })] }) }) }) }), _jsx(TestScenarioSideBarMenu, {})] }));
}
function TestScenarioParserErrorPanel({ parserErrorTitle, parserErrorMessage, }) {
    return (_jsx(Flex, { justifyContent: { default: "justifyContentCenter" }, style: { marginTop: "100px" }, children: _jsxs(EmptyState, { style: { maxWidth: "1280px" }, children: [_jsx(EmptyStateIcon, { icon: () => _jsx("div", { style: { fontSize: "3em" }, children: "\uD83D\uDE15" }) }), _jsx(Title, { size: "lg", headingLevel: "h4", children: parserErrorTitle }), _jsx("br", {}), _jsxs(EmptyStateBody, { children: ["Error details: ", parserErrorMessage] })] }) }));
}
export const TestScenarioEditorInternal = ({ forwardRef, model, onModelChange, onModelDebounceStateChanged, }) => {
    console.debug("[TestScenarioEditorInternal] Component creation ...");
    const scesim = useTestScenarioEditorStore((s) => s.scesim);
    const testScenarioEditorStoreApi = useTestScenarioEditorStoreApi();
    const { testScenarioEditorModelBeforeEditingRef, testScenarioEditorRootElementRef } = useTestScenarioEditor();
    const { commandsRef } = useCommands();
    useImperativeHandle(forwardRef, () => ({
        reset: () => {
            console.debug("[TestScenarioEditorInternal: Reset called!");
            const state = testScenarioEditorStoreApi.getState();
            state.dispatch(state).navigation.reset();
        },
        getCommands: () => commandsRef.current,
        getDiagramSvg: async () => undefined,
    }), [commandsRef, testScenarioEditorStoreApi]);
    useEffectAfterFirstRender(() => {
        testScenarioEditorStoreApi.setState((state) => {
            if (model === state.scesim.model) {
                console.debug("[TestScenarioEditorInternal]: useEffectAfterFirstRender called, but the models are the same!");
                return;
            }
            console.debug("[TestScenarioEditorInternal]: Model updated!");
            state.scesim.model = model;
            testScenarioEditorModelBeforeEditingRef.current = model;
        });
    }, [testScenarioEditorStoreApi, model]);
    useEffectAfterFirstRender(() => {
        onModelDebounceStateChanged === null || onModelDebounceStateChanged === void 0 ? void 0 : onModelDebounceStateChanged(false);
        const timeout = setTimeout(() => {
            if (model === scesim.model) {
                return;
            }
            onModelDebounceStateChanged === null || onModelDebounceStateChanged === void 0 ? void 0 : onModelDebounceStateChanged(true);
            console.debug("[TestScenarioEditorInternal: Debounce State changed!", scesim.model);
            onModelChange === null || onModelChange === void 0 ? void 0 : onModelChange(scesim.model);
        }, 500);
        return () => {
            clearTimeout(timeout);
        };
    }, [onModelChange, scesim.model]);
    const scesimFileStatus = useMemo(() => {
        var _a;
        if (scesim) {
            const parserErrorField = "parsererror";
            if (!scesim.model ||
                !scesim.model.ScenarioSimulationModel ||
                scesim.model.ScenarioSimulationModel[parserErrorField]) {
                return TestScenarioFileStatus.ERROR;
            }
            if (scesim.model.ScenarioSimulationModel["@_version"] != CURRENT_SUPPORTED_VERSION) {
                return TestScenarioFileStatus.UNSUPPORTED;
            }
            else if ((_a = scesim.model.ScenarioSimulationModel.settings) === null || _a === void 0 ? void 0 : _a.type) {
                return TestScenarioFileStatus.VALID;
            }
            else {
                return TestScenarioFileStatus.NEW;
            }
        }
        else {
            return TestScenarioFileStatus.EMPTY;
        }
    }, [scesim]);
    console.debug("[TestScenarioEditorInternal] File Status: ", TestScenarioFileStatus[scesimFileStatus]);
    return (_jsx("div", { ref: testScenarioEditorRootElementRef, className: "kie-scesim-editor--root", "data-testid": "kie-scesim-editor--container", children: (() => {
            switch (scesimFileStatus) {
                case TestScenarioFileStatus.EMPTY:
                    return (_jsx(Bullseye, { children: _jsx(Spinner, { "aria-label": "SCESIM Data loading .." }) }));
                case TestScenarioFileStatus.ERROR:
                    return (_jsx(TestScenarioParserErrorPanel, { parserErrorTitle: "File parsing error", parserErrorMessage: "Impossibile to correctly parse the provided scesim file. Most likely, the XML structure of the file " +
                            "is invalid." }));
                case TestScenarioFileStatus.NEW:
                    return _jsx(TestScenarioCreationPanel, {});
                case TestScenarioFileStatus.UNSUPPORTED:
                    return (_jsx(TestScenarioParserErrorPanel, { parserErrorTitle: "This file holds a Test Scenario asset version (" +
                            scesim.model.ScenarioSimulationModel["@_version"] +
                            ") not supported", parserErrorMessage: "Most likely, this file has been generated with a very old Business Central version (< 7.30.0.Final). " +
                            "Please update your Business Central instance and download again this scesim file, it will be automatically updated to the supported version (" +
                            CURRENT_SUPPORTED_VERSION +
                            ")." }));
                case TestScenarioFileStatus.VALID:
                    return _jsx(TestScenarioMainPanel, {});
            }
        })() }));
};
export const TestScenarioEditor = React.forwardRef((props, ref) => {
    console.debug("[TestScenarioEditor] Component creation ... ", props.model);
    const store = useMemo(() => createTestScenarioEditorStore(props.model, new ComputedStateCache(INITIAL_COMPUTED_CACHE)), []);
    const storeRef = React.useRef(store);
    const resetState = useCallback(({ args }) => {
        var _a;
        (_a = storeRef.current) === null || _a === void 0 ? void 0 : _a.setState((state) => {
            state.scesim.model = args[0];
        });
    }, []);
    return (_jsx(I18nDictionariesProvider, { defaults: testScenarioEditorI18nDefaults, dictionaries: testScenarioEditorDictionaries, initialLocale: navigator.language, ctx: TestScenarioEditorI18nContext, children: _jsx(TestScenarioEditorContextProvider, { ...props, children: _jsx(ErrorBoundary, { FallbackComponent: TestScenarioEditorErrorFallback, onReset: resetState, children: _jsx(TestScenarioEditorExternalModelsContextProvider, { ...props, children: _jsx(TestScenarioEditorStoreApiContext.Provider, { value: storeRef.current, children: _jsx(CommandsContextProvider, { children: _jsx(TestScenarioEditorInternal, { forwardRef: ref, ...props }) }) }) }) }) }) }));
});
//# sourceMappingURL=TestScenarioEditor.js.map