"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.openWidget = openWidget;
var monaco_editor_1 = require("monaco-editor");
var WIDGET_CONTAINER_DIV_ID = "widget-container";
var widgetsStore = new WeakMap();
function openWidget(editorInstance, args) {
    var _this = this;
    var _a, _b, _c, _d;
    var widgetPosition = {
        position: args.position,
        preference: [monaco_editor_1.editor.ContentWidgetPositionPreference.BELOW, monaco_editor_1.editor.ContentWidgetPositionPreference.ABOVE],
    };
    var widgetId = args.widgetId + Math.random();
    var widget = {
        suppressMouseDown: true,
        getId: function () { return widgetId; },
        getPosition: function () { return widgetPosition; },
        getDomNode: function () {
            if (!args.domNodeHolder.value) {
                args.domNodeHolder.value = document.createElement("div");
                args.domNodeHolder.value.style.background = args.backgroundColor;
                args.domNodeHolder.value.style.userSelect = "text";
                args.domNodeHolder.value.style.paddingRight = "14px";
                args.domNodeHolder.value.style.width = "99999px";
                args.domNodeHolder.value.style.zIndex = "99999";
                args.domNodeHolder.value.style.marginTop = "-1.2em";
                var button = document.createElement("button");
                args.domNodeHolder.value.appendChild(button);
                button.innerText = "Close";
                button.style.float = "right";
                button.onclick = function () { return __awaiter(_this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        args.onClose({ container: getWidgetContainer(args.domNodeHolder) });
                        editorInstance.removeContentWidget({
                            getId: function () { return widgetId; },
                            getPosition: function () { return widgetPosition; },
                            getDomNode: function () { return args.domNodeHolder.value; },
                        });
                        return [2];
                    });
                }); };
            }
            var widgetContainer = document.createElement("div");
            widgetContainer.setAttribute("id", WIDGET_CONTAINER_DIV_ID);
            args.domNodeHolder.value.appendChild(widgetContainer);
            return args.domNodeHolder.value;
        },
    };
    widgetsStore.set(editorInstance, (_a = widgetsStore.get(editorInstance)) !== null && _a !== void 0 ? _a : new Map());
    (_c = (_b = widgetsStore.get(editorInstance)) === null || _b === void 0 ? void 0 : _b.get(args.position.lineNumber)) === null || _c === void 0 ? void 0 : _c.close();
    editorInstance.addContentWidget(widget);
    (_d = widgetsStore.get(editorInstance)) === null || _d === void 0 ? void 0 : _d.set(args.position.lineNumber, {
        close: function () {
            args.onClose({ container: getWidgetContainer(args.domNodeHolder) });
            editorInstance.removeContentWidget(widget);
        },
    });
    args.onReady({ container: getWidgetContainer(args.domNodeHolder) });
}
function getWidgetContainer(domNodeHolder) {
    return domNodeHolder.value.querySelector("#" + WIDGET_CONTAINER_DIV_ID);
}
//# sourceMappingURL=index.js.map