import { EditorInitArgs, EditorTheme, KogitoEditorEnvelopeContextType } from "@kie-tools-core/editor/dist/api";
import { Notification } from "@kie-tools-core/notifications/dist/api";
import { Position } from "monaco-editor";
import { ServerlessWorkflowTextEditorApi, ServerlessWorkflowTextEditorChannelApi, ServerlessWorkflowTextEditorEnvelopeApi } from "../api";
export declare class ServerlessWorkflowTextEditorView implements ServerlessWorkflowTextEditorApi {
    private readonly envelopeContext;
    private readonly initArgs;
    private readonly editorRef;
    af_isReact: boolean;
    af_componentId: "serverless-workflow-text-editor";
    af_componentTitle: "Serverless Workflow Text Editor";
    constructor(envelopeContext: KogitoEditorEnvelopeContextType<ServerlessWorkflowTextEditorEnvelopeApi, ServerlessWorkflowTextEditorChannelApi>, initArgs: EditorInitArgs);
    setContent(normalizedPosixPathRelativeToTheWorkspaceRoot: string, content: string): Promise<void>;
    getContent(): Promise<string>;
    getPreview(): Promise<string | undefined>;
    af_componentRoot(): JSX.Element;
    undo(): Promise<void>;
    redo(): Promise<void>;
    validate(): Promise<Notification[]>;
    setTheme(theme: EditorTheme): Promise<void>;
    moveCursorToNode(nodeName: string): void;
    moveCursorToPosition(position: Position): void;
}
//# sourceMappingURL=ServerlessWorkflowTextEditorView.d.ts.map