import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { connectField } from "uniforms";
import wrapField from "@kie-tools/uniforms-patternfly/dist/esm/wrapField";
function DmnFeelContext({ onChange, ...props }) {
    var _a;
    const stringifiedValue = useMemo(() => {
        if (props.value && typeof props.value === "object") {
            return JSON.stringify(props.value);
        }
        return props.value;
    }, [props.value]);
    const onTextInputChange = useCallback((value, event) => {
        try {
            const parsedObject = JSON.parse(event.target.value);
            onChange(parsedObject);
        }
        catch (err) {
            onChange(event.target.value);
        }
    }, [onChange]);
    return wrapField(props, _jsx(_Fragment, { children: _jsx(TextInput, { "aria-label": "uniforms context field", name: props.name, isDisabled: props.disabled, validated: props.error ? "error" : "default", onChange: onTextInputChange, placeholder: props.placeholder, ref: props.inputRef, type: (_a = props.type) !== null && _a !== void 0 ? _a : "text", value: stringifiedValue !== null && stringifiedValue !== void 0 ? stringifiedValue : "" }) }));
}
export const DmnFeelContextField = connectField(DmnFeelContext);
//# sourceMappingURL=DmnFeelContextField.js.map