import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import _ from "lodash";
import { EmptyState, EmptyStateBody, EmptyStateIcon, EmptyStateSecondaryActions, } from "@patternfly/react-core/dist/js/components/EmptyState";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { convertActionsToButton } from "@kie-tools/runtime-tools-components/dist/utils";
const EmptyTaskForm = ({ userTask, formSchema, enabled, submit, ouiaId, ouiaSafe, }) => {
    const canTransition = () => {
        return !userTask.completed && !_.isEmpty(formSchema.phases);
    };
    const buildFormActions = () => {
        return formSchema.phases.map((phase) => {
            return {
                name: phase,
                execute: () => {
                    submit(phase);
                },
            };
        });
    };
    const actions = canTransition() ? (_jsx(EmptyStateSecondaryActions, { children: convertActionsToButton(buildFormActions(), enabled) })) : null;
    return (_jsx(Bullseye, { ...componentOuiaProps(ouiaId, "empty-task-form", ouiaSafe), children: _jsxs(EmptyState, { variant: "large", children: [_jsx(EmptyStateIcon, { icon: InfoCircleIcon, color: "var(--pf-global--info-color--100)" }), _jsx(Title, { headingLevel: "h4", size: "lg", children: "Cannot show task form" }), _jsxs(EmptyStateBody, { children: [_jsxs("p", { children: ["Task", " ", _jsxs("b", { children: [userTask.referenceName, " (", userTask.id.substring(0, 5), ")"] }), "\u00A0doesn't have a form to show. This usually means that it doesn't require data to be filled by the user."] }), canTransition() && (_jsxs(_Fragment, { children: [_jsx("br", {}), _jsx("p", { children: "You can still use the actions bellow to move the task to the next phase." })] }))] }), actions] }) }));
};
export default EmptyTaskForm;
//# sourceMappingURL=EmptyTaskForm.js.map