import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useRef, useState, useCallback } from "react";
import { v4 as uuidv4 } from "uuid";
import { generateFormData } from "../utils/TaskFormDataUtils";
import { Stack, StackItem } from "@patternfly/react-core/layouts/Stack";
import { Bullseye } from "@patternfly/react-core/layouts/Bullseye";
import { buildTaskFormContext } from "./utils/utils";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { FormFooter } from "@kie-tools/runtime-tools-components/dist/components/FormFooter";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { EmbeddedFormDisplayer, FormOpenedState, FormSubmitResponseType, } from "@kie-tools/runtime-tools-shared-enveloped-components/dist/formDisplayer";
const CustomTaskFormDisplayer = ({ userTask, customForm, schema, user, driver, phases, targetOrigin, ouiaId, ouiaSafe, }) => {
    const formDisplayerApiRef = useRef(null);
    const [formUUID] = useState(uuidv4());
    const [formData] = useState(generateFormData(userTask));
    const [formActions, setFormActions] = useState([]);
    const [formOpened, setFormOpened] = useState();
    const [submitted, setSubmitted] = useState(false);
    const doSubmit = useCallback(async (phase, payload) => {
        const formDisplayerApi = formDisplayerApiRef.current;
        try {
            const response = await driver.doSubmit(phase, payload);
            formDisplayerApi.notifySubmitResult({
                type: FormSubmitResponseType.SUCCESS,
                info: response,
            });
        }
        catch (error) {
            formDisplayerApi.notifySubmitResult({
                type: FormSubmitResponseType.FAILURE,
                info: error,
            });
        }
        finally {
            setSubmitted(true);
        }
    }, [driver]);
    useEffect(() => {
        if (phases) {
            const actions = phases.map((phase) => {
                return {
                    name: phase,
                    execute: () => {
                        const formDisplayerApi = formDisplayerApiRef.current;
                        formDisplayerApi
                            .startSubmit({
                            params: {
                                phase: phase,
                            },
                        })
                            .then((formOutput) => doSubmit(phase, formOutput))
                            .catch((error) => console.log(`Couldn't submit form due to: ${error}`));
                    },
                };
            });
            setFormActions(actions);
        }
    }, [doSubmit, phases]);
    useEffect(() => {
        if (formOpened) {
            document.getElementById(`${formUUID}-form`).style.visibility = "visible";
        }
    }, [formOpened, formUUID]);
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "custom-form-displayer", ouiaSafe), style: { height: "100%" }, children: [!formOpened && (_jsx(Bullseye, { ...componentOuiaProps((ouiaId ? ouiaId : "task-form-envelope-view") + "-loading-spinner", "task-form", true), children: _jsx(KogitoSpinner, { spinnerText: `Loading Task form...` }) })), _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { id: `${formUUID}-form`, style: { visibility: "hidden", height: "inherit" }, children: _jsx(EmbeddedFormDisplayer, { targetOrigin: targetOrigin, envelopePath: "resources/form-displayer.html", formContent: customForm, data: formData, context: buildTaskFormContext(userTask, schema, user), onOpenForm: (opened) => setFormOpened(opened), ref: formDisplayerApiRef }) }), formOpened && formOpened.state === FormOpenedState.OPENED && (_jsx(StackItem, { children: _jsx(FormFooter, { actions: formActions, enabled: !submitted }) }))] })] }));
};
export default CustomTaskFormDisplayer;
//# sourceMappingURL=CustomTaskFormDisplayer.js.map