import { jsx as _jsx } from "react/jsx-runtime";
import React, { useCallback, useMemo } from "react";
import { RefForwardingEmbeddedEnvelope } from "@kie-tools-core/envelope/dist/embedded";
import { ProcessListChannelApiImpl } from "./ProcessListChannelApiImpl";
import { ContainerType } from "@kie-tools-core/envelope/dist/api";
import { init } from "../envelope";
export const EmbeddedProcessList = React.forwardRef((props, forwardedRef) => {
    const refDelegate = useCallback((envelopeServer) => ({}), []);
    const pollInit = useCallback(async (envelopeServer, container) => {
        await init({
            config: {
                containerType: ContainerType.DIV,
                envelopeId: envelopeServer.id,
            },
            container: container(),
            bus: {
                postMessage(message, targetOrigin, transfer) {
                    window.postMessage(message, targetOrigin, transfer);
                },
            },
        });
        return envelopeServer.envelopeApi.requests.processList__init({
            origin: envelopeServer.origin,
            envelopeServerId: envelopeServer.id,
        }, {
            initialState: { ...props.initialState },
            singularProcessLabel: props.singularProcessLabel,
            pluralProcessLabel: props.pluralProcessLabel,
        });
    }, [props.initialState, props.pluralProcessLabel, props.singularProcessLabel]);
    const apiImpl = useMemo(() => {
        return new ProcessListChannelApiImpl(props.driver);
    }, [props.driver]);
    return (_jsx(EmbeddedProcessListEnvelope, { ref: forwardedRef, apiImpl: apiImpl, origin: props.targetOrigin, refDelegate: refDelegate, pollInit: pollInit, config: { containerType: ContainerType.DIV } }));
});
const EmbeddedProcessListEnvelope = React.forwardRef(RefForwardingEmbeddedEnvelope);
//# sourceMappingURL=EmbeddedProcessList.js.map