import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { Stack, StackItem } from "@patternfly/react-core/layouts/Stack";
import { useCallback, useEffect, useRef, useState } from "react";
import { v4 as uuidv4 } from "uuid";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { EmbeddedFormDisplayer, FormOpenedState, FormSubmitResponseType, } from "@kie-tools/runtime-tools-shared-enveloped-components/dist/formDisplayer";
import { FormFooter } from "@kie-tools/runtime-tools-components/dist/components/FormFooter";
const CustomProcessFormDisplayer = ({ customForm, driver, targetOrigin, ouiaId, ouiaSafe, }) => {
    const formDisplayerApiRef = useRef(null);
    const [formUUID] = useState(uuidv4());
    const [formData] = useState({});
    const [formActions, setFormActions] = useState([]);
    const [formOpened, setFormOpened] = useState();
    const [submitted, setSubmitted] = useState(false);
    const doSubmit = useCallback(async (payload) => {
        const formDisplayerApi = formDisplayerApiRef.current;
        try {
            const response = await driver.startProcess(payload);
            formDisplayerApi.notifySubmitResult({
                type: FormSubmitResponseType.SUCCESS,
                info: response,
            });
        }
        catch (error) {
            formDisplayerApi.notifySubmitResult({
                type: FormSubmitResponseType.FAILURE,
                info: error,
            });
        }
        finally {
            setSubmitted(true);
        }
    }, [driver]);
    useEffect(() => {
        setFormActions([
            {
                name: "Start",
                execute: () => {
                    const formDisplayerApi = formDisplayerApiRef.current;
                    formDisplayerApi
                        .startSubmit({
                        params: {},
                    })
                        .then((formOutput) => doSubmit(formOutput))
                        .catch((error) => console.log(`Couldn't submit form due to: ${error}`));
                },
            },
        ]);
    }, [doSubmit]);
    return (_jsx("div", { ...componentOuiaProps(ouiaId, "custom-form-displayer", ouiaSafe), style: { height: "100%" }, children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { id: `${formUUID}-form`, style: { visibility: "visible", height: "inherit" }, children: _jsx(EmbeddedFormDisplayer, { targetOrigin: targetOrigin, envelopePath: "resources/form-displayer.html", formContent: customForm, data: formData, context: {}, onOpenForm: (opened) => setFormOpened(opened), ref: formDisplayerApiRef }) }), formOpened && formOpened.state === FormOpenedState.OPENED && (_jsx(StackItem, { children: _jsx(FormFooter, { actions: formActions, enabled: !submitted }) }))] }) }));
};
export default CustomProcessFormDisplayer;
//# sourceMappingURL=CustomProcessFormDisplayer.js.map