import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback } from "react";
import { TextContent, Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { Modal } from "@patternfly/react-core/dist/js/components/Modal";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import Moment from "react-moment";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
export const JobsDetailsModal = ({ actionType, modalTitle, isModalOpen, modalAction, handleModalToggle, job, ouiaId, ouiaSafe, }) => {
    const checkNumericProperty = useCallback((propertyValue) => {
        return propertyValue !== undefined && propertyValue !== null;
    }, []);
    const modalContent = useCallback(() => {
        return (_jsx("div", { className: "kogito-management-console-shared--jobsModal__detailsModal", children: _jsx(TextContent, { children: _jsxs(Flex, { direction: { default: "column" }, children: [job.processId && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: [_jsx(Text, { component: TextVariants.h6, children: "Process Id: " }), " "] }), _jsx(SplitItem, { children: job.processId })] }) })), job.processInstanceId && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: [" ", _jsx(Text, { component: TextVariants.h6, children: "Process Instance Id: " }), " "] }), _jsx(SplitItem, { children: job.processInstanceId })] }) })), job.nodeInstanceId && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Node Instance Id: " }) }), _jsx(SplitItem, { children: job.nodeInstanceId })] }) })), _jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: [_jsx(Text, { component: TextVariants.h6, children: "Status: " }), " "] }), _jsx(SplitItem, { children: job.status })] }) }), checkNumericProperty(job.priority) && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsxs(SplitItem, { children: [_jsx(Text, { component: TextVariants.h6, children: "Priority: " }), " "] }), _jsx(SplitItem, { children: job.priority })] }) })), checkNumericProperty(job.repeatInterval) && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Repeat Interval: " }) }), _jsx(SplitItem, { children: job.repeatInterval })] }) })), checkNumericProperty(job.repeatLimit) && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Repeat Limit: " }) }), _jsx(SplitItem, { children: job.repeatLimit })] }) })), job.scheduledId && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Scheduled Id: " }) }), _jsx(SplitItem, { children: job.scheduledId })] }) })), checkNumericProperty(job.retries) && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Retries: " }) }), _jsx(SplitItem, { children: job.retries })] }) })), checkNumericProperty(job.executionCounter) && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Execution counter: " }) }), _jsx(SplitItem, { children: job.executionCounter })] }) })), job.lastUpdate && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsx(Text, { component: TextVariants.h6, children: "Last Updated: " }) }), _jsx(SplitItem, { children: _jsx(Moment, { fromNow: true, children: new Date(`${job.lastUpdate}`) }) })] }) })), job.callbackEndpoint && (_jsx(FlexItem, { children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { children: _jsxs(Text, { component: TextVariants.h6, className: "kogito-management-console-shared--jobsModal__text", children: ["Callback Endpoint:", " "] }) }), _jsx(SplitItem, { children: job.callbackEndpoint })] }) }))] }) }) }));
    }, [job, checkNumericProperty]);
    return (_jsx(Modal, { variant: "large", "aria-labelledby": actionType + "modal", "aria-label": actionType + "modal", title: "", header: modalTitle, isOpen: isModalOpen, onClose: handleModalToggle, actions: modalAction, ...componentOuiaProps(ouiaId, "job-details-modal", ouiaSafe), children: modalContent() }));
};
//# sourceMappingURL=JobsDetailsModal.js.map