import { Job, JobStatus, BulkCancel, JobOperationResult, JobsSortBy } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
export interface JobsManagementDriver {
    initialLoad(filter: JobStatus[], orderBy: JobsSortBy): Promise<void>;
    applyFilter(filter: JobStatus[]): Promise<void>;
    bulkCancel(jobsToBeActioned: Job[]): Promise<BulkCancel>;
    cancelJob(job: Pick<Job, "id" | "endpoint">): Promise<JobOperationResult>;
    rescheduleJob(job: Job, repeatInterval: number | string, repeatLimit: number | string, scheduleDate: Date): Promise<{
        modalTitle: string;
        modalContent: string;
    }>;
    sortBy(orderBy: JobsSortBy): Promise<void>;
    query(offset: number, limit: number): Promise<Job[]>;
}
//# sourceMappingURL=JobsManagementDriver.d.ts.map