"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePreviousRef = usePreviousRef;
var react_1 = require("react");
function usePreviousRef(value) {
    var ref = (0, react_1.useRef)(value);
    (0, react_1.useEffect)(function () {
        if (ref.current !== value) {
            ref.current = value;
        }
    }, [value]);
    return ref;
}
//# sourceMappingURL=usePreviousRef.js.map