import { ValidationEntry } from "./ValidationRegistry";
import { ValidationLevel } from "./ValidationLevel";
import { Builder } from "../paths";
export const validateOutputs = (modelIndex, outputFields, miningFields, validationRegistry) => {
    if (outputFields.length === 0) {
        validationRegistry.set(Builder().forModel(modelIndex).forOutput().build(), new ValidationEntry(ValidationLevel.WARNING, `At least one Output Field is required.`));
    }
    outputFields === null || outputFields === void 0 ? void 0 : outputFields.forEach((outputField, dataDictionaryIndex) => validateOutput(modelIndex, outputField, dataDictionaryIndex, miningFields, validationRegistry));
};
export const validateOutput = (modelIndex, outputField, outputFieldIndex, miningFields, validationRegistry) => {
    if (isOutputsTargetFieldRequired(miningFields) && outputField.targetField === undefined) {
        validationRegistry.set(Builder().forModel(modelIndex).forOutput().forOutputField(outputFieldIndex).forTargetField().build(), new ValidationEntry(ValidationLevel.WARNING, `"${outputField.name}": target field is required if Mining Schema has multiple target fields.`));
    }
};
export const isOutputsTargetFieldRequired = (miningFields) => {
    return miningFields.filter((field) => field.usageType === "target").length > 1;
};
//# sourceMappingURL=Outputs.js.map