import { ValidationEntry } from "./ValidationRegistry";
import { ValidationLevel } from "./ValidationLevel";
import { Builder } from "../paths";
export const validateDataFields = (dataFields, validationRegistry) => {
    dataFields.forEach((dataField, dataDictionaryIndex) => validateDataField(dataField, dataDictionaryIndex, validationRegistry));
};
export const validateDataField = (dataField, dataDictionaryIndex, validationRegistry) => {
    var _a, _b, _c;
    (_a = dataField.Interval) === null || _a === void 0 ? void 0 : _a.forEach((interval, index) => {
        if (interval.leftMargin === undefined && interval.rightMargin === undefined) {
            validationRegistry.set(Builder().forDataDictionary().forDataField(dataDictionaryIndex).forInterval(index).build(), new ValidationEntry(ValidationLevel.WARNING, `"${dataField.name}" data type, Interval (${index + 1}) must have the start and/or end value set.`));
        }
    });
    (_b = dataField.Value) === null || _b === void 0 ? void 0 : _b.forEach((value, index) => {
        if (value.value === "") {
            validationRegistry.set(Builder().forDataDictionary().forDataField(dataDictionaryIndex).forValue(index).build(), new ValidationEntry(ValidationLevel.WARNING, `"${dataField.name}" data type, Empty Constraint Value (${index + 1})`));
        }
    });
    if (dataField.dataType === "string" && dataField.optype === "ordinal") {
        if (!hasValidValues(dataField)) {
            validationRegistry.set(Builder().forDataDictionary().forDataField(dataDictionaryIndex).forInterval().build(), new ValidationEntry(ValidationLevel.WARNING, `"${dataField.name}" data type, Values list required for ordinal strings`));
        }
    }
    if (dataField.isCyclic === "1") {
        if (dataField.optype === "ordinal" && !hasValidValues(dataField)) {
            validationRegistry.set(Builder().forDataDictionary().forDataField(dataDictionaryIndex).forValue().build(), new ValidationEntry(ValidationLevel.WARNING, `"${dataField.name}" data type, Values list is required for cyclic ordinal data types`));
        }
        if (dataField.optype === "continuous") {
            if (!hasValidValues(dataField) && !hasIntervals(dataField)) {
                validationRegistry.set(Builder().forDataDictionary().forDataField(dataDictionaryIndex).forInterval().build(), new ValidationEntry(ValidationLevel.WARNING, `"${dataField.name}" data type, A Value or Interval constraint is required for cyclic continuous data types`));
            }
            if (dataField.Interval && ((_c = dataField.Interval) === null || _c === void 0 ? void 0 : _c.length) > 1) {
                validationRegistry.set(Builder().forDataDictionary().forDataField(dataDictionaryIndex).forInterval().build(), new ValidationEntry(ValidationLevel.WARNING, `"${dataField.name}" data type, Continuous data types can have only a single interval constraint`));
            }
        }
    }
};
export const hasValidValues = (dataField) => {
    return (dataField.Value &&
        dataField.Value.filter((value) => value.property === "valid" || value.property === undefined).length > 0);
};
export const hasIntervals = (dataField) => {
    return dataField.Interval && dataField.Interval.length > 0;
};
export const hasOnlyEmptyIntervals = (dataField) => {
    var _a;
    return (_a = dataField.Interval) === null || _a === void 0 ? void 0 : _a.every((interval) => interval.leftMargin === undefined && interval.rightMargin === undefined);
};
export const hasOnlyEmptyValues = (dataField) => {
    var _a;
    const validValues = (_a = dataField.Value) === null || _a === void 0 ? void 0 : _a.filter((value) => value.property === undefined || value.property === "valid");
    return validValues === null || validValues === void 0 ? void 0 : validValues.every((value) => value.value === "");
};
export const shouldConstraintsBeCleared = (updatedDataField, isCyclic, dataType, optype) => {
    let result = false;
    if (isCyclic === "1" &&
        updatedDataField.isCyclic !== "1" &&
        !(updatedDataField.optype === "ordinal" && updatedDataField.dataType === "string") &&
        (hasOnlyEmptyIntervals(updatedDataField) || hasOnlyEmptyValues(updatedDataField))) {
        result = true;
    }
    if (isCyclic !== "1" &&
        updatedDataField.isCyclic !== "1" &&
        (updatedDataField.optype !== "ordinal" || updatedDataField.dataType !== "string") &&
        optype === "ordinal" &&
        dataType === "string" &&
        hasOnlyEmptyValues(updatedDataField)) {
        result = true;
    }
    return result;
};
//# sourceMappingURL=DataDictionary.js.map