import { getModelType } from "../PMMLModelHelper";
var get = Reflect.get;
const reduce = (model, action, reducers) => {
    var _a;
    const modelType = getModelType(model);
    const reducer = reducers.get(modelType);
    return (_a = reducer === null || reducer === void 0 ? void 0 : reducer.factory(reducer.reducer(model, action))) !== null && _a !== void 0 ? _a : model;
};
export const DelegatingModelReducer = (historyService, reducers) => {
    return (state, action) => {
        if (state === undefined || action === undefined || action.payload === undefined) {
            return state;
        }
        let changed = false;
        const newState = [];
        state.forEach((m) => newState.push(m));
        const modelIndex = get(action.payload, "modelIndex");
        if (modelIndex === undefined) {
            state.forEach((model, index) => {
                const modelAction = Object.assign({}, action, { payload: { ...action.payload, modelIndex: index } });
                const newModel = reduce(model, modelAction, reducers);
                if (model !== newModel) {
                    changed = true;
                    newState[index] = newModel;
                }
            });
        }
        if (modelIndex >= 0 && modelIndex < state.length) {
            const model = state[modelIndex];
            const newModel = reduce(model, action, reducers);
            if (model !== newModel) {
                changed = true;
                newState[modelIndex] = newModel;
            }
        }
        if (changed) {
            return newState;
        }
        return state;
    };
};
//# sourceMappingURL=DelegatingModelReducer.js.map