import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { PageSection, PageSectionVariants } from "@patternfly/react-core/dist/js/components/Page";
import { EditorHeader } from "../../EditorCore/molecules";
import { RegressionModel } from "@kie-tools/pmml-editor-marshaller";
import { getModelName } from "../../..";
import { useSelector } from "react-redux";
import "./LinearRegressionViewerPage.scss";
import { EmptyStateModelNotFound } from "../../EditorCore/organisms";
import { LinearRegressionViewAdaptor } from "../molecules";
export const LinearRegressionViewerPage = (props) => {
    const { modelIndex } = props;
    const model = useSelector((state) => {
        const _model = state.models ? state.models[modelIndex] : undefined;
        if (_model && _model instanceof RegressionModel) {
            const _regressionModel = _model;
            if (_regressionModel.functionName === "regression" && _regressionModel.algorithmName === "linearRegression") {
                return _regressionModel;
            }
        }
        return undefined;
    });
    return (_jsxs("div", { "data-testid": "editor-page", className: "editor", children: [!model && _jsx(EmptyStateModelNotFound, {}), model && (_jsxs(_Fragment, { children: [_jsx(PageSection, { variant: PageSectionVariants.light, isFilled: false, children: _jsx(EditorHeader, { modelName: getModelName(model), modelIndex: modelIndex }) }), _jsx(PageSection, { isFilled: true, style: { paddingTop: "0px" }, children: _jsx(LinearRegressionViewAdaptor, { model: model }) })] }))] }));
};
//# sourceMappingURL=LinearRegressionViewerPage.js.map