import { jsx as _jsx } from "react/jsx-runtime";
import { useEffect, useState } from "react";
import { Scorecard, } from "@kie-tools/pmml-editor-marshaller";
import { AttributesTableRow } from "../molecules";
import "./AttributesTable.scss";
import { Operation } from "../Operation";
import { useSelector } from "react-redux";
import { useOperation } from "../OperationContext";
export const AttributesTable = (props) => {
    const { modelIndex, characteristicIndex, characteristic, areReasonCodesUsed, viewAttribute, deleteAttribute, onCommit, } = props;
    const { setActiveOperation } = useOperation();
    const [attributeFocusIndex, setAttributeFocusIndex] = useState(undefined);
    const dataFields = useSelector((state) => {
        return state.DataDictionary.DataField;
    });
    const miningFields = useSelector((state) => {
        const _model = state.models ? state.models[props.modelIndex] : undefined;
        if (_model && _model instanceof Scorecard) {
            return _model.MiningSchema.MiningField;
        }
        return [];
    });
    useEffect(() => {
        var _a;
        if (attributeFocusIndex !== undefined) {
            (_a = document.querySelector(`#attribute-n${attributeFocusIndex}`)) === null || _a === void 0 ? void 0 : _a.focus();
        }
    }, [characteristic.Attribute, attributeFocusIndex]);
    const onEdit = (index) => {
        setActiveOperation(Operation.UPDATE_ATTRIBUTE);
        viewAttribute(index);
    };
    const handleDelete = (index, interaction) => {
        var _a;
        onDelete(index);
        if (interaction === "mouse") {
            if (document.activeElement instanceof HTMLElement) {
                (_a = document.activeElement) === null || _a === void 0 ? void 0 : _a.blur();
            }
        }
        else if (interaction === "keyboard") {
            setAttributeFocusIndex(index);
        }
    };
    const onDelete = (index) => {
        if (index !== undefined) {
            deleteAttribute(index);
        }
    };
    return (_jsx("section", { "data-testid": "attributes-table", children: characteristic.Attribute.map((attribute, index) => {
            return (_jsx("article", { className: `editable-item attribute-item-n${index}`, children: _jsx(AttributesTableRow, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic, attributeIndex: index, attribute: attribute, areReasonCodesUsed: areReasonCodesUsed, characteristicReasonCode: characteristic.reasonCode, dataFields: dataFields, miningFields: miningFields, onEdit: () => onEdit(index), onDelete: (interaction) => handleDelete(index, interaction), onCommit: (partial) => onCommit(index, partial) }, index) }, index));
        }) }));
};
//# sourceMappingURL=AttributesTable.js.map