import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Stack, StackItem } from "@patternfly/react-core/dist/js/layouts/Stack";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Alert } from "@patternfly/react-core/dist/js/components/Alert";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Radio } from "@patternfly/react-core/dist/js/components/Radio";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
import { ArrowAltCircleLeftIcon } from "@patternfly/react-icons/dist/js/icons/arrow-alt-circle-left-icon";
import { ConstraintType } from "../DataDictionaryContainer/DataDictionaryContainer";
import ConstraintsEdit from "../ConstraintsEdit/ConstraintsEdit";
import "./DataDictionaryPropertiesEdit.scss";
const DataDictionaryPropertiesEdit = (props) => {
    var _a, _b, _c;
    const { dataType, dataFieldIndex, onClose, onSave } = props;
    const [displayName, setDisplayName] = useState((_a = dataType.displayName) !== null && _a !== void 0 ? _a : "");
    const [isCyclic, setIsCyclic] = useState(dataType.isCyclic);
    const [missingValue, setMissingValue] = useState((_b = dataType.missingValue) !== null && _b !== void 0 ? _b : "");
    const [invalidValue, setInvalidValue] = useState((_c = dataType.invalidValue) !== null && _c !== void 0 ? _c : "");
    useEffect(() => {
        var _a, _b, _c;
        setDisplayName((_a = dataType.displayName) !== null && _a !== void 0 ? _a : "");
        setIsCyclic(dataType.isCyclic);
        setMissingValue((_b = dataType.missingValue) !== null && _b !== void 0 ? _b : "");
        setInvalidValue((_c = dataType.invalidValue) !== null && _c !== void 0 ? _c : "");
    }, [dataType]);
    const saveCyclicProperty = (value) => {
        setIsCyclic(value);
        onSave({
            isCyclic: value,
        });
    };
    const isOptypeDisabled = useMemo(() => dataType.optype === "categorical", [dataType.optype]);
    const constraintAlert = useMemo(() => {
        var _a, _b;
        if (dataType.optype === "continuous" && dataType.isCyclic && dataType.constraints === undefined) {
            return "Interval or Value constraints are required for cyclic continuous data types";
        }
        if (dataType.isCyclic &&
            dataType.optype === "continuous" &&
            ((_a = dataType.constraints) === null || _a === void 0 ? void 0 : _a.type) === ConstraintType.RANGE &&
            ((_b = dataType.constraints.value) === null || _b === void 0 ? void 0 : _b.length) > 1) {
            return "Cyclic continuous data types can only have a single interval constraint";
        }
    }, [dataType]);
    return (_jsxs(Stack, { hasGutter: true, className: "data-dictionary__properties-edit", children: [_jsx(StackItem, { children: _jsxs(Title, { headingLevel: "h4", size: TitleSizes.xl, children: [_jsx(Button, { variant: "link", isInline: true, onClick: onClose, children: dataType.name }), "\u00A0/\u00A0Properties"] }) }), _jsx(StackItem, { className: "data-dictionary__properties-edit__form-container", "data-ouia-component-id": "df-props", "data-ouia-component-type": "editor-body", children: _jsx(Form, { className: "data-dictionary__properties-edit__form", children: _jsxs(Split, { hasGutter: true, children: [_jsx(SplitItem, { className: "data-dictionary__properties-edit__form__left-column", children: _jsxs(Stack, { hasGutter: true, children: [_jsx(StackItem, { children: _jsx(FormGroup, { className: "data-dictionary__properties-edit__field", label: "Display Name", fieldId: "display-name", helperText: "Display Name to use instead of the data type name", children: _jsx(TextInput, { type: "text", id: "display-name", name: "display-name", "aria-describedby": "Display Name", value: displayName, onChange: (value) => setDisplayName(value), autoComplete: "off", onBlur: () => onSave({
                                                        displayName: displayName === "" ? undefined : displayName,
                                                    }), ouiaId: "display-name" }) }) }), _jsx(StackItem, { children: _jsxs(FormGroup, { className: "data-dictionary__properties-edit__field", label: "Cyclic Type", fieldId: "is-cyclic", isInline: true, labelIcon: dataType.optype === "categorical" ? (_jsx(Tooltip, { content: "Categorical fields cannot be cyclic", children: _jsx("button", { "aria-label": "More info for Cyclic Type", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) })) : (_jsx(_Fragment, {})), children: [_jsx(Radio, { isChecked: isCyclic === true, name: "isCyclic", onChange: () => {
                                                            saveCyclicProperty(true);
                                                        }, label: "Yes", id: "isCyclic", value: "isCyclic", isDisabled: isOptypeDisabled }), _jsx(Radio, { isChecked: isCyclic === false, name: "isNotCyclic", onChange: () => {
                                                            saveCyclicProperty(false);
                                                        }, label: "No", id: "isNotCyclic", value: "isNotCyclic", isDisabled: isOptypeDisabled }), _jsx(Radio, { isChecked: isCyclic === undefined, name: "cyclicNotSet", onChange: () => {
                                                            saveCyclicProperty(undefined);
                                                        }, label: "Not Set", id: "cyclicNotSet", value: "cyclicNotSet", isDisabled: isOptypeDisabled })] }) }), _jsx(StackItem, { children: _jsx(FormGroup, { className: "data-dictionary__properties-edit__field", label: "Missing Value", fieldId: "missing-value", helperText: "Value for when the input is missing", children: _jsx(TextInput, { type: "text", id: "missing-value", name: "missing-value", "aria-describedby": "Missing Value", value: missingValue, onChange: (value) => setMissingValue(value), autoComplete: "off", onBlur: () => onSave({
                                                        missingValue: missingValue === "" ? undefined : missingValue,
                                                    }), ouiaId: "missing-value" }) }) }), _jsx(StackItem, { children: _jsx(FormGroup, { className: "data-dictionary__properties-edit__field", label: "Invalid Value", fieldId: "missing-value", helperText: "Value for when the input is invalid", children: _jsx(TextInput, { type: "text", id: "invalid-value", name: "invalid-value", "aria-describedby": "Invalid Value", value: invalidValue, onChange: (value) => setInvalidValue(value), autoComplete: "off", onBlur: () => onSave({
                                                        invalidValue: invalidValue === "" ? undefined : invalidValue,
                                                    }), ouiaId: "invalid-value" }) }) })] }) }), _jsx(SplitItem, { isFilled: true, children: _jsxs("section", { className: "data-dictionary__constraints-section", children: [constraintAlert && (_jsx(Alert, { variant: "warning", isInline: true, className: "data-dictionary__validation-alert", title: constraintAlert })), _jsx(ConstraintsEdit, { dataType: dataType, dataFieldIndex: dataFieldIndex, onSave: onSave })] }) })] }) }) }), _jsx(StackItem, { children: _jsx(Button, { variant: "primary", onClick: onClose, icon: _jsx(ArrowAltCircleLeftIcon, {}), iconPosition: "left", ouiaId: "back-to-DFs", children: "Back" }) })] }));
};
export default DataDictionaryPropertiesEdit;
//# sourceMappingURL=DataDictionaryPropertiesEdit.js.map