export class WorkflowFormEnvelopeApiImpl {
    constructor(args) {
        this.args = args;
        this.capturedInitRequestYet = false;
        this.workflowForm__init = async (association, workflowDefinition) => {
            this.args.envelopeClient.associate(association.origin, association.envelopeServerId);
            if (this.hasCapturedInitRequestYet()) {
                return;
            }
            this.view = await this.args.viewDelegate();
            this.ackCapturedInitRequest();
            this.view().initialize(workflowDefinition);
        };
    }
    hasCapturedInitRequestYet() {
        return this.capturedInitRequestYet;
    }
    ackCapturedInitRequest() {
        this.capturedInitRequestYet = true;
    }
}
//# sourceMappingURL=WorkflowFormEnvelopeApiImpl.js.map