import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useState, useCallback } from "react";
import { Flex, FlexItem } from "@patternfly/react-core/dist/js/layouts/Flex";
import { Grid, GridItem } from "@patternfly/react-core/dist/js/layouts/Grid";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Modal, ModalVariant } from "@patternfly/react-core/dist/js/components/Modal";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { OverflowMenu, OverflowMenuContent, OverflowMenuGroup, } from "@patternfly/react-core/dist/js/components/OverflowMenu";
import { Card } from "@patternfly/react-core/dist/js/components/Card";
import { Title, TitleSizes } from "@patternfly/react-core/dist/js/components/Title";
import { SyncIcon } from "@patternfly/react-icons/dist/js/icons/sync-icon";
import { InfoCircleIcon } from "@patternfly/react-icons/dist/js/icons/info-circle-icon";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { KogitoSpinner } from "@kie-tools/runtime-tools-components/dist/components/KogitoSpinner";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { TitleType } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
import { setTitle } from "@kie-tools/runtime-tools-components/dist/utils/Utils";
import { WorkflowInfoModal } from "@kie-tools/runtime-tools-components/dist/components/WorkflowInfoModal";
import JobsPanel from "../JobsPanel/JobsPanel";
import "../styles.css";
import WorkflowDetailsPanel from "../WorkflowDetailsPanel/WorkflowDetailsPanel";
import WorkflowDetailsNodeTrigger from "../WorkflowDetailsNodeTrigger/WorkflowDetailsNodeTrigger";
import WorkflowVariables from "../WorkflowVariables/WorkflowVariables";
import WorkflowDetailsMilestonesPanel from "../WorkflowDetailsMilestonesPanel/WorkflowDetailsMilestonesPanel";
import WorkflowDetailsTimelinePanel from "../WorkflowDetailsTimelinePanel/WorkflowDetailsTimelinePanel";
import SwfCombinedEditor from "../SwfCombinedEditor/SwfCombinedEditor";
import { JobStatus, WorkflowInstanceState, } from "@kie-tools/runtime-tools-swf-gateway-api/dist/types";
const SWFCOMBINEDEDITOR_WIDTH = 1000;
const CHECK_EXPIRED_JOBS_TIMEOUT = 5000;
const WorkflowDetails = ({ isEnvelopeConnectedToChannel, driver, workflowDetails }) => {
    var _a;
    const [data, setData] = useState({});
    const [jobs, setJobs] = useState([]);
    const [updateJson, setUpdateJson] = useState({});
    const [displayLabel, setDisplayLabel] = useState(false);
    const [displaySuccess, setDisplaySuccess] = useState(false);
    const [errorModalOpen, setErrorModalOpen] = useState(false);
    const [confirmationModal, setConfirmationModal] = useState(false);
    const [variableError, setVariableError] = useState("");
    const [error, setError] = useState("");
    const [isLoading, setIsLoading] = useState(false);
    const [isInfoModalOpen, setIsInfoModalOpen] = useState(false);
    const [infoModalTitle, setInfoModalTitle] = useState("");
    const [titleType, setTitleType] = useState("");
    const [infoModalContent, setInfoModalContent] = useState("");
    const handleReload = async () => {
        setIsLoading(true);
        try {
            const workflowResponse = await driver.workflowDetailsQuery(workflowDetails.id);
            workflowResponse && setData(workflowResponse);
            loadJobs();
            setIsLoading(false);
        }
        catch (errorString) {
            setError(errorString);
            setIsLoading(false);
        }
    };
    const loadJobs = useCallback(async () => {
        const jobsResponse = await driver.jobsQuery(workflowDetails.id);
        jobsResponse && setJobs(jobsResponse);
    }, [workflowDetails.id, driver]);
    const checkExpiredJobs = useCallback(async () => {
        await new Promise((resolve) => setTimeout(resolve, CHECK_EXPIRED_JOBS_TIMEOUT));
        const scheduledJobs = jobs.filter((job) => job.status === JobStatus.Scheduled);
        if (!scheduledJobs.length) {
            return;
        }
        const expiredJob = scheduledJobs.find((job) => new Date(job.expirationTime) < new Date());
        if (expiredJob) {
            loadJobs();
            return;
        }
        checkExpiredJobs();
    }, [loadJobs, jobs]);
    useEffect(() => {
        jobs.length && checkExpiredJobs();
    }, [jobs, checkExpiredJobs]);
    useEffect(() => {
        const getVariableJSON = () => {
            if (data && data.id === workflowDetails.id) {
                setUpdateJson(typeof data.variables === "string" ? JSON.parse(data.variables) : data.variables);
            }
        };
        if (isEnvelopeConnectedToChannel) {
            getVariableJSON();
        }
    }, [data, isEnvelopeConnectedToChannel, workflowDetails.id]);
    useEffect(() => {
        if (variableError && variableError.length > 0) {
            setErrorModalOpen(true);
        }
    }, [variableError]);
    useEffect(() => {
        if (isEnvelopeConnectedToChannel) {
            setData(workflowDetails);
            loadJobs();
        }
    }, [isEnvelopeConnectedToChannel]);
    const handleSave = () => {
        driver
            .handleWorkflowVariableUpdate(data, updateJson)
            .then((updatedJson) => {
            setUpdateJson(updatedJson);
            setDisplayLabel(false);
            setDisplaySuccess(true);
            setTimeout(() => {
                setDisplaySuccess(false);
            }, 2000);
        })
            .catch((errorMessage) => {
            setVariableError(errorMessage);
        });
    };
    const updateVariablesButton = () => {
        if (data.serviceUrl !== null) {
            return (_jsx(Button, { variant: "secondary", id: "save-button", className: "kogito-workflow-details--details__buttonMargin", onClick: handleSave, isDisabled: !displayLabel, "data-testid": "save-button", children: "Save" }));
        }
        return _jsx(_Fragment, {});
    };
    const handleRefresh = () => {
        if (displayLabel === true) {
            setConfirmationModal(true);
        }
        else {
            handleReload();
        }
    };
    const refreshButton = () => {
        return (_jsx(Button, { variant: "plain", onClick: () => {
                handleRefresh();
            }, id: "refresh-button", "data-testid": "refresh-button", "aria-label": "Refresh list", children: _jsx(SyncIcon, {}) }));
    };
    const handleInfoModalToggle = () => {
        setIsInfoModalOpen(!isInfoModalOpen);
    };
    const onAbortClick = async (workflowInstance) => {
        try {
            await driver.handleWorkflowAbort(workflowInstance);
            setTitleType(TitleType.SUCCESS);
            setInfoModalTitle("Abort operation");
            setInfoModalContent(`The workflow ${workflowInstance.processName} was successfully aborted.`);
        }
        catch (abortError) {
            setTitleType(TitleType.FAILURE);
            setInfoModalTitle("Abort operation");
            setInfoModalContent(`Failed to abort workflow ${workflowInstance.processName}. Message: ${abortError.message}`);
        }
        finally {
            handleInfoModalToggle();
        }
    };
    const abortButton = () => {
        var _a;
        if ((data.state === WorkflowInstanceState.Active ||
            data.state === WorkflowInstanceState.Error ||
            data.state === WorkflowInstanceState.Suspended) &&
            ((_a = data.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) &&
            data.serviceUrl !== null) {
            return (_jsx(Button, { variant: "secondary", id: "abort-button", "data-testid": "abort-button", onClick: () => onAbortClick(data), children: "Abort" }));
        }
        else {
            return (_jsx(Button, { variant: "secondary", isDisabled: true, children: "Abort" }));
        }
    };
    const renderSwfDiagram = () => {
        return (_jsx(Flex, { children: _jsx(FlexItem, { children: _jsx(SwfCombinedEditor, { height: 1000, width: SWFCOMBINEDEDITOR_WIDTH, workflowInstance: data }) }) }));
    };
    const renderWorkflowTimeline = () => {
        return (_jsx(FlexItem, { children: _jsx(WorkflowDetailsTimelinePanel, { data: data, jobs: jobs, driver: driver }) }));
    };
    const renderWorkflowDetails = () => {
        return (_jsxs(Flex, { direction: { default: "column" }, flex: { default: "flex_1" }, children: [_jsx(FlexItem, { children: _jsx(WorkflowDetailsPanel, { workflowInstance: data, driver: driver }) }), data.milestones && data.milestones.length > 0 && (_jsx(FlexItem, { children: _jsx(WorkflowDetailsMilestonesPanel, { milestones: data.milestones }) }))] }));
    };
    const renderWorkflowVariables = () => {
        return (_jsx(Flex, { direction: { default: "column" }, flex: { default: "flex_1" }, children: updateJson && Object.keys(updateJson).length > 0 && (_jsx(FlexItem, { children: _jsx(WorkflowVariables, { displayLabel: displayLabel, displaySuccess: displaySuccess, setUpdateJson: setUpdateJson, setDisplayLabel: setDisplayLabel, updateJson: updateJson, workflowInstance: data }) })) }));
    };
    const renderPanels = () => {
        return (_jsxs(Flex, { direction: { default: "column" }, children: [renderSwfDiagram(), _jsxs(Flex, { style: { width: `${SWFCOMBINEDEDITOR_WIDTH}px` }, children: [renderWorkflowDetails(), renderWorkflowVariables()] })] }));
    };
    const handleConfirmationModal = () => {
        setConfirmationModal(!confirmationModal);
    };
    const handleConfirm = () => {
        window.location.reload();
        handleConfirmationModal();
    };
    const handleCancel = () => {
        handleConfirmationModal();
    };
    const RenderConfirmationModal = () => {
        return (_jsx(Modal, { title: "", header: _jsx(_Fragment, { children: _jsxs(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: [_jsx(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--warning-color--100)" }), "Refresh"] }) }), variant: ModalVariant.small, isOpen: confirmationModal, onClose: handleConfirmationModal, actions: [
                _jsx(Button, { variant: "primary", id: "confirm-button", onClick: handleConfirm, children: "Ok" }, "Ok"),
                _jsx(Button, { variant: "link", id: "cancel-button", onClick: handleCancel, children: "Cancel" }, "Cancel"),
            ], "aria-label": "Confirmation modal", "aria-labelledby": "Confirmation modal", children: "This action discards changes made on workflow variables." }));
    };
    const handleErrorModal = () => {
        setErrorModalOpen(!errorModalOpen);
    };
    const handleRetry = () => {
        handleErrorModal();
        setVariableError("");
        handleSave();
    };
    const handleDiscard = () => {
        handleErrorModal();
        handleRefresh();
    };
    const errorModal = () => {
        return (_jsx(Modal, { title: "", header: _jsx(_Fragment, { children: _jsxs(Title, { headingLevel: "h1", size: TitleSizes["2xl"], children: [_jsx(InfoCircleIcon, { className: "pf-u-mr-sm", color: "var(--pf-global--danger-color--100)" }), "Error"] }) }), variant: ModalVariant.small, isOpen: errorModalOpen, onClose: handleErrorModal, actions: [
                _jsx(Button, { variant: "primary", id: "retry-button", onClick: handleRetry, children: "Retry" }, "Retry"),
                _jsx(Button, { variant: "link", id: "discard-button", onClick: handleDiscard, children: "Discard" }, "Discard"),
            ], "aria-label": "Error modal", "aria-labelledby": "Error modal", children: variableError }));
    };
    return (_jsxs(_Fragment, { children: [!error ? (_jsx(_Fragment, { children: !isLoading && Object.keys(data).length > 0 ? (_jsxs(_Fragment, { children: [_jsx(Grid, { hasGutter: true, md: 1, span: 12, lg: 6, xl: 4, children: _jsx(GridItem, { span: 12, children: _jsxs(Split, { hasGutter: true, component: "div", className: "pf-u-align-items-center", children: [_jsx(SplitItem, { isFilled: true, children: _jsx(Title, { headingLevel: "h2", size: "4xl", className: "kogito-workflow-details--details__title", children: _jsx(ItemDescriptor, { itemDescription: {
                                                        id: data.id,
                                                        name: data.processName,
                                                        description: data.businessKey,
                                                    } }) }) }), _jsx(SplitItem, { children: _jsx(OverflowMenu, { breakpoint: "lg", children: _jsx(OverflowMenuContent, { isPersistent: true, children: _jsx(OverflowMenuGroup, { groupType: "button", isPersistent: true, children: _jsxs(_Fragment, { children: [updateVariablesButton(), abortButton(), refreshButton()] }) }) }) }) })] }) }) }), _jsxs(Flex, { direction: { default: "column", lg: "row" }, className: "kogito-workflow-details--details__marginSpaces", children: [renderPanels(), _jsxs(Flex, { direction: { default: "column" }, flex: { default: "flex_1" }, children: [renderWorkflowTimeline(), _jsx(FlexItem, { children: _jsx(JobsPanel, { jobs: jobs, driver: driver }) }), ((_a = data.addons) === null || _a === void 0 ? void 0 : _a.includes("workflow-management")) &&
                                            data.state !== WorkflowInstanceState.Completed &&
                                            data.state !== WorkflowInstanceState.Aborted &&
                                            data.serviceUrl &&
                                            data.addons.includes("workflow-management") && (_jsx(FlexItem, { children: _jsx(WorkflowDetailsNodeTrigger, { driver: driver, workflowInstanceData: data }) }))] }), errorModal(), RenderConfirmationModal()] })] })) : (_jsx(Card, { children: _jsx(KogitoSpinner, { spinnerText: "Loading workflow details..." }) })) })) : (_jsx(_Fragment, { children: isEnvelopeConnectedToChannel && (_jsx(Card, { className: "kogito-workflow-details__card-size", children: _jsx(Bullseye, { children: _jsx(ServerErrors, { error: error, variant: "large" }) }) })) })), _jsx(WorkflowInfoModal, { isModalOpen: isInfoModalOpen, handleModalToggle: handleInfoModalToggle, modalTitle: setTitle(titleType, infoModalTitle), modalContent: infoModalContent, workflowName: data && data.processName })] }));
};
export default WorkflowDetails;
//# sourceMappingURL=WorkflowDetails.js.map