import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import * as ReactDOM from "react-dom";
import { Envelope } from "@kie-tools-core/envelope";
import { JobsManagementEnvelopeView } from "./JobsManagementEnvelopeView";
import { JobsManagementEnvelopeApiImpl } from "./JobsManagementEnvelopeApiImpl";
export function init(args) {
    const envelope = new Envelope(args.bus, args.config);
    const envelopeViewDelegate = async () => {
        const ref = React.createRef();
        return new Promise((res) => {
            ReactDOM.render(_jsx(JobsManagementEnvelopeView, { ref: ref, channelApi: envelope.channelApi }), args.container, () => res(() => ref.current));
        });
    };
    const context = {};
    return envelope.start(envelopeViewDelegate, context, {
        create: (apiFactoryArgs) => new JobsManagementEnvelopeApiImpl(apiFactoryArgs),
    });
}
//# sourceMappingURL=JobsManagementEnvelope.js.map